from django.shortcuts import render,redirect
from django.http import HttpResponse, HttpRequest
from django.contrib.auth.models import User
from django.contrib.auth import authenticate, login, logout
from django.contrib.auth.decorators import login_required

# Create your views here.
@login_required
def homepage_view(request):
	#get the user object and send in context
	return render(request, 'viewreq.html', context=None)

def login_view(request):
	"""View function for login page of site"""
	if request.method == 'GET':
		#check if user is authenticated
		if request.user.is_authenticated:
			return redirect('homepage')
			# return render(request, 'viewreq.html', context=None)
		else:
			return render(request, 'login.html')

	elif request.method == 'POST':
		# return HttpResponse('<p> Great! logged in!</p>')
		username = request.POST['username']
		password = request.POST['password']
		user = authenticate(request, username=username, password=password)

		if user is not None:
			login(request, user)
			return redirect(request.POST.get('next','homepage'))
		else:
			return render(request, 'login.html', context={'error_msg':'Invalid Username/Password.'})
			# return render(request, 'viewreq.html', context=None)

def logout_view(request):
	if request.user.is_authenticated:
		logout(request)
		return HttpResponse('<p> Successfully logged out! Please refresh to go to main page.</p>')
	else:
		return redirect('base')

@login_required
def rebate(request):
	return render(request, 'rebates.html')

def overhead(request):
	return render(request, 'overheads.html')

def viewreq(request):
	return render(request, 'viewreq.html')

def apprreq(request):
	return render(request, 'apprreq.html')

def todaycount(request):
	return render(request, 'todaycount.html')

def apprebate(request):
	return render(request, 'apprebate.html')

def monthlyrepo(request):
	return render(request, 'monthlyrepo.html')

def dailyreqhist(request):
	return render(request, 'dialyreqhist.html')