
from django.urls import path
from . import views

#Add URL maps to redirect the base URL to our application
from django.views.generic import RedirectView

urlpatterns = [
	path('', RedirectView.as_view(url='login/'), name='base'),
	path('homepage/', views.homepage_view, name='homepage'),
	path('login/', views.login_view, name='login'),
	path('logout/', views.logout_view, name='logout'),

	## student functions below:
	path('rebate/',views.rebate, name='rebate'), 
	path('overhead/',views.overhead, name='overhead'),
	#this is to be redirected to homepage
	path('viewreq/',views.viewreq),
	## worker's functions below:
	path('apprreq/',views.apprreq),
	path('todaycount/',views.todaycount),
	## manager's functions below:
	path('apprebate/',views.apprebate),
	path('monthlyrepo/',views.monthlyrepo),
	path('dailyreqhist/',views.dailyreqhist)
]