from django.contrib.auth.models import User, Group
from django.shortcuts import redirect

def is_manager(user):
	return user.groups.filter(name='manager').exists()

def is_worker(user):
	return user.groups.filter(name='worker').exists()

def is_student(user):
	return user.groups.filter(name='student').exists()

def homepage_redirect(request):
	user=request.user
	if is_manager(user):
		return redirect('manager-homepage')
	elif is_worker(user):
		return redirect('worker-homepage')
	else: #is_student(user):
		return redirect('student-homepage')