
from django.urls import path
from . import views

#Add URL maps to redirect the base URL to our application
from django.views.generic import RedirectView

urlpatterns = [
	path('', RedirectView.as_view(url='login/'), name='base'),
	path('login/', views.login_view, name='login'),
	path('logout/', views.logout_view, name='logout'),
	path('homepage/', views.homepage_view, name='homepage'),
	path('student/', views.student_homepage_view, name='student-homepage'),
	path('manager/', views.manager_homepage_view, name='manager-homepage'),
	path('worker/', views.worker_homepage_view, name='worker-homepage'),

	## student functions below:
	path('rebate/',views.rebate), 
	path('overhead/',views.overhead),
	#this is to be redirected to homepage
	path('viewreq/',views.viewreq),
	## worker's functions below:
	path('apprreq/',views.apprreq),
	path('todaycount/',views.todaycount),
	## manager's functions below:
	path('apprebate/',views.apprebate),
	path('monthlyrepo/',views.monthlyrepo),
	path('dailyreqhist/',views.dailyreqhist)
]