class ComplexNumber:
	real = 0.0
	img = 0.0
	def __init__(self,real,img):
		self.real = real
		self.img = img

	def __str__(self):
		return "(%s,%s)" %(self.real,self.img)


	def __repr__(self):
		return "ComplexNumber(real=%s,img=%s)" %(self.real,self.img)

	def __radd__(self,other):
		return ComplexNumber(self.real + other,self.img)

	def __add__(self,other):
		sum_real = self.real + other.real
		sum_img = self.img + other.img
		return ComplexNumber(sum_real,sum_img)

	def __sub__(self,other):
		sub_real = self.real - other.real
		sub_img = self.img - other.img
		return ComplexNumber(sub_real,sub_img)

	def __mul__(self,other):
		mul_real = self.real*other.real-self.img*other.img
		mul_img = self.real*other.img + self.img*other.real
		return ComplexNumber(mul_real,mul_img)

	def __rmul__(self,other):
		rmul_real = self.real*other
		rmul_img = self.img*other
		return ComplexNumber(rmul_real,rmul_img)

	def __truediv__(self,other):
		div_real = (self.real*other.real+self.img*other.img)/(other.real**2+other.img**2)
		div_img = (self.img*other.real - self.real*other.img)/(other.real**2+other.img**2)
		return ComplexNumber(div_real,div_img)

	def __eq__(self,other):	
		if(self.real==other.real and self.img==other.img):
			return True
		else:
			return False	

	def __pow__(self,other):
		if other==0:
			return ComplexNumber(1,0)
		else:
			if (other%2)==0:
				y = self**(other/2)
				z = y*y
				return z
			else:
				y = self**(other-1)
				z = self*y
				return z
				
	def mysquare(variable):
		return variable*variable

