#include "KVServerClient.h"
#include <bits/stdc++.h>
#include "mutex"
#include "vector"
#include "helper.h"
#include "unistd.h"
#include <iostream>
#include <memory>
#include <string>
#include <thread>
#include "unordered_map"
#include <grpc/support/log.h>
#include <grpcpp/grpcpp.h>
#include "unordered_map"
#include "utility"
#include "keyvaluepackage.grpc.pb.h"
#include <iterator>
#include <set>
#include <list>
#include <fstream>
using grpc::Server;
using grpc::ServerAsyncResponseWriter;
using grpc::ServerBuilder;
using grpc::ServerCompletionQueue;
using grpc::ServerContext;
using grpc::Status;
using keyvaluepackage::KV;
using keyvaluepackage::GetKeyRequest;
using keyvaluepackage::Reply;
using keyvaluepackage::PutKeyRequest;
using keyvaluepackage::DelKeyRequest;
std::mutex door;
std::unordered_map<std::string,std::pair<int,std::string>> keyFeqValue;
std::set<std::pair<int,std::string>> feqKeq;
int NUM_OF_RECORD;

std::mutex m,serverlck;
std::list<std::pair<std::string, std::string>> cacheLRU;
std::unordered_map<std::string, std::list<std::pair<std::string, std::string>>::iterator> cacheLRUMap;
int cacheLRU_size = 100;
std::pair<int, int> search_key(std::string file_name, std::string key) {
    std::fstream myfile;


    myfile.open(file_name, myfile.out| myfile.in);

    myfile.seekg(0, myfile.end);

    int file_length = myfile.tellg();

    // std::cout << file_length << '\n';

    int num_records = file_length / 513;


    char key_record[257];
    char val_record[257];

    key_record[256] = '\0';
    val_record[256] = '\0';

    char status[1];

    std::string my_key;
    std::string my_val;

    int last_empty_record = -1;

    bool flag = false;

    myfile.seekg(0, myfile.beg);

    int key_line_index = -1;

    // std::cout << num_records;

    for (int i = 0; i < num_records; i++) {
        my_key = "";
        my_val = "";
        myfile.read(status, 1);
        // myfile.seekg(1, myfile.cur);
        myfile.read(key_record, 256);
        // myfile.seekg(256, myfile.cur);
        myfile.read(val_record, 256);
        // myfile.seekg(256, myfile.cur);

        for(int j = 0; j < 256; j++) {
            if (key_record[j] == ' ') break;
            // std::cout << key_record[j];
            my_key += key_record[j];
        }


        for(int j = 0; j < 256; j++) {
            if (val_record[j] == ' ') break;
            my_val += val_record[j];
        }


        if (status[0] == '1') {
            if (my_key == key) {
                // found record.
                // std::cout << "hahsdasd";
                key_line_index = i;
                break;
            }

        } else {
            last_empty_record = i;
        }


    }

    myfile.close();

    return std::make_pair(key_line_index, last_empty_record);
}

std::pair<std::string,std::string> NotInRange(std::string file_name, std::string upper, std::string lower)
{
    std::fstream myfile;


    myfile.open(file_name, myfile.out| myfile.in);

    myfile.seekg(0, myfile.end);

    int file_length = myfile.tellg();

    // std::cout << file_length << '\n';

    int num_records = file_length / 513;


    char key_record[257];
    char val_record[257];

    key_record[256] = '\0';
    val_record[256] = '\0';

    char status[1];

    std::string my_key;
    std::string my_val;

    int last_empty_record = -1;

    bool flag = false;

    myfile.seekg(0, myfile.beg);

    int key_line_index = -1;

    // std::cout << num_records;
    std::pair<std::string,std::string> ans;
    for (int i = 0; i < num_records; i++) {
        my_key = "";
        my_val = "";
        myfile.read(status, 1);
        // myfile.seekg(1, myfile.cur);
        myfile.read(key_record, 256);
        // myfile.seekg(256, myfile.cur);
        myfile.read(val_record, 256);
        // myfile.seekg(256, myfile.cur);

        for(int j = 0; j < 256; j++) {
            if (key_record[j] == ' ') break;
            // std::cout << key_record[j];
            my_key += key_record[j];
        }


        for(int j = 0; j < 256; j++) {
            if (val_record[j] == ' ') break;
            my_val += val_record[j];
        }


        if (status[0] == '1') {
            if (upper > lower) {
                if(my_key <= upper && lower < my_key)
                {
                    ans.first+=my_key;
                    ans.first+=';';
                    ans.second+=my_val;
                    ans.second+=";";
                }
                // found record.
                // std::cout << "hahsdasd";
            } else
            {
                if(upper>=my_key || lower <= my_key)
                {
                    ans.first+=my_key;
                    ans.first+=';';
                    ans.second+=my_val;
                    ans.second+=";";
                }
            }

        }


    }

    myfile.close();

    return ans;
}
std::pair<std::string, std::string> get_from_file(std::string file_name, std::string key) {
    std::pair<int, int> search_result = search_key(file_name, key);

    char key_record[257];
    char val_record[257];

    key_record[256] = '\0';
    val_record[256] = '\0';

    char status[1];

    std::string my_key;
    std::string my_val;

    std::fstream myfile;


    myfile.open(file_name, myfile.out| myfile.in);

    if (search_result.first != -1) {

        // std::cout << "hoora";
        // found the entry

        myfile.seekg(search_result.first * 513, myfile.beg);


        myfile.read(status, 1);
        // myfile.seekg(1, myfile.cur);
        myfile.read(key_record, 256);
        // myfile.seekg(256, myfile.cur);
        // std::cout << myfile.tellg() << '\n';
        myfile.read(val_record, 256);
        // myfile.seekg(256, myfile.cur);

        // std::cout << val_record[0] << '\n';

        for(int j = 0; j < 256; j++) {
            if (key_record[j] == ' ') break;
            // std::cout << key_record[j];
            my_key += key_record[j];
        }


        for(int j = 0; j < 256; j++) {
            if (val_record[j] == ' ') break;
            my_val += val_record[j];
        }

        myfile.close();

        return std::make_pair(my_key, my_val);
    }

    myfile.close();

    return std::make_pair("NULL", "NULL");

}
void put_to_file(std::string file_name, std::string key, std::string value) {
    std::pair<int, int> search_result = search_key(file_name, key);


    char key_record[257];
    char val_record[257];

    key_record[256] = '\0';
    val_record[256] = '\0';

    char status[1];

    std::string my_key;
    std::string my_val;


    std::fstream myfile;


    myfile.open(file_name, myfile.out| myfile.in);

    if (search_result.first != -1) {

        // std::cout << "hoora";
        // found the entry
        myfile.seekg(search_result.first * 513 + 256 + 1, myfile.beg);

        std::string padding(256-value.size(), ' ');

        myfile << value.c_str();
        // myfile.write(value.c_str(), value.size());
        myfile << padding.c_str();

    } else {
        if (search_result.second != -1) {
            myfile.seekg(search_result.second * 513, myfile.beg);
        } else {
            myfile.seekg(0, myfile.end);
        }

        status[0] = '1';
        myfile << status[0];
        // myfile.write(status, 1);

        std::string padding_1(256-key.size(), ' ');

        myfile << key.c_str();
        // myfile.write(key.c_str(), key.size());
        myfile << padding_1.c_str();
        // myfile.write(padding_1.c_str(), padding_1.size());


        std::string padding_2(256-value.size(), ' ');

        myfile << value.c_str();
        // myfile.write(value.c_str(), value.size());
        myfile << padding_2.c_str();
        // myfile.write(padding_2.c_str(), padding_2.size());

    }

    myfile.close();

}
int del_from_file(std::string file_name, std::string key) {
    std::pair<int, int> search_result = search_key(file_name, key);


    char key_record[257];
    char val_record[257];

    key_record[256] = '\0';
    val_record[256] = '\0';

    char status[1];

    std::string my_key;
    std::string my_val;


    std::fstream myfile;


    myfile.open(file_name, myfile.out| myfile.in);

    if (search_result.first != -1) {

        // std::cout << "hoora";
        // found the entry

        myfile.seekg(search_result.first * 513, myfile.beg);

        status[0] = '0';
        myfile << status[0];

        myfile.close();

        return 0;
    }

    myfile.close();

    return -1;

}
int create_files(std::string file_name) {

    std::fstream myfile;

    for (int i = 0; i < 1; i++) {
        myfile.open(file_name, myfile.out);

        if (myfile.fail()) {
            // unsuccessful to create and open a file.
            std::cout << "unsuccessful" << i << '\n';
            return -1;
        }

        myfile.close();
    }

    return 0;
}
std::string file_name,NodeHashValue;
struct conf configData;
struct fingerTable fTable;
class ServerImpl final {
public:
    ~ServerImpl() {
        server_->Shutdown();
        // Always shutdown the completion queue after the server.
        cq_[0]->Shutdown();
    }
    void Run() {
        NUM_OF_RECORD=configData.cache_size/512;
        cacheLRU_size=NUM_OF_RECORD;
        std::string server_address("0.0.0.0:"+ std::to_string(configData.chordserverport));
        NodeHashValue=hashValue(std::to_string(configData.chordserverport));
        ServerBuilder builder;
        // Listen on the given address without any authentication mechanism.
        builder.AddListeningPort(server_address, grpc::InsecureServerCredentials());
        // Register "service_" as the instance through which we'll communicate with
        // clients. In this case it corresponds to an *asynchronous* service.
        builder.RegisterService(&service_);
        file_name=NodeHashValue+".txt";
        create_files(file_name);
        // Get hold of the completion queue used for the asynchronous communication
        // with the gRPC runtime.
        for (int i = 0; i < configData.thread_pool; ++i) {
            cq_.push_back( builder.AddCompletionQueue());
        }

        // Finally assemble the server.
        server_ = builder.BuildAndStart();
        std::cout << "Server listening on" << server_address << std::endl;

        // Proceed to the server's main loop.
        std::thread th[configData.thread_pool];


        //update a finger table of other node
        for (int i = 5000; i <configData.chordserverport ; ++i) {
            connectNxt(2,std::to_string(i),"-1",std::to_string(configData.chordserverport));
        }
        fTable=updateFingerTable(configData.chordserverport,configData.chordserverport);
        std::cout<<"My port number "<<configData.chordserverport<<" Nxt server "<<fTable.table[0]<<" Predecessor "<<fTable.predecessor<<std::endl;

        int arr[100];
        for (int i = 0; i < configData.thread_pool; ++i) {
            arr[i]=i;
            if(configData.cache_replacement=="LRU")
                th[i]=std::thread(&ServerImpl::HandleRpcsLRU, this,arr[i]);
            else {

                th[i] = std::thread(&ServerImpl::HandleRpcsLFU, this, arr[i]);
            }
        }
        for (int i = 0; i < configData.thread_pool; ++i) {
            th[i].join();
        }
    }
private:
    // Class encompasing the state and logic needed to serve a request.
    class CallDataLRU {
    public:

        CallDataLRU(KV::AsyncService * service, ServerCompletionQueue * cq, int type)
                : service_(service), responder_(&ctx_), cq_(cq), status_(CREATE)
        {
            type_of_request = type;
            // Invoke the serving logic right away.
            Proceed();
        }

        std::pair<std::string, std::string> get_value(std::string key)
        {
            m.lock();
            std::string fetched_value;
            if (cacheLRUMap.find(key) == cacheLRUMap.end()) {
                // cache entry not found. find it from file.
                fetched_value = "NOT FOUND";

                fetched_value = get_from_file(file_name, key).second;

                // check if the cache is full
                if (cacheLRU.size() == cacheLRU_size) {
                    // deleting the least recently used entry which is stored at the last
                    std::pair<std::string, std::string> last = cacheLRU.back();
                    cacheLRU.pop_back();

                    // deleting the map entry
                    cacheLRUMap.erase(last.first);
                }

            } else {
                fetched_value = (*cacheLRUMap[key]).second;
                cacheLRU.erase(cacheLRUMap[key]);
            }

            // putting the recently accessed key-value pair at the front
            std::pair<std::string, std::string> key_val(key, fetched_value);
            cacheLRU.push_front(key_val);
            cacheLRUMap[key] = cacheLRU.begin();

            m.unlock();

            return key_val;
        }

        void put_key_value(std::string key, std::string value)
        {
            m.lock();


            std::pair<std::string, std::string> key_val(key, value);

            // check if the cache is full
            if (cacheLRU.size() == cacheLRU_size) {
                // deleting the least recently used entry which is stored at the last
                std::pair<std::string, std::string> last = cacheLRU.back();
                cacheLRU.pop_back();

                // deleting the map entry
                cacheLRUMap.erase(last.first);
            }

            // putting the recently accessed key-value pair at the front
            cacheLRU.push_front(key_val);
            cacheLRUMap[key] = cacheLRU.begin();

            // Store the key-value pair in a file
            put_to_file(file_name, key, value);

            m.unlock();
        }

        int delete_key_value(std::string key)
        {
            m.lock();


            if (cacheLRUMap.find(key) != cacheLRUMap.end()) {
                cacheLRU.erase(cacheLRUMap[key]);
                cacheLRUMap.erase(key);
            }

            // delete key-value entry from the file

            int status = del_from_file(file_name, key);


            m.unlock();
            return status;
        }

        void Proceed() {
            if (status_ == CREATE) {
                // Make this instance progress to the PROCESS state.
                status_ = PROCESS;
                // As part of the initial CREATE state, we *request* that the system
                // start processing SayHello requests. In this request, "this" acts are
                // the tag uniquely identifying the request (so that different CallData
                // instances can serve different requests concurrently), in this case
                // the memory address of this CallData instance.
                if(type_of_request==0){
                    service_->RequestGET(&ctx_,&request_get,&responder_,cq_,cq_,this);
                }else if(type_of_request==1){
                    service_->RequestPUT(&ctx_,&request_put,&responder_,cq_,cq_,this);
                }else if(type_of_request==2){
                    service_->RequestDEL(&ctx_,&request_del,&responder_,cq_,cq_,this);
                }

            }
            else if (status_ == PROCESS) {


                //business logic
                if(request_put.key()=="-1")
                {
                    //New Server is added and need of update a finger table
                    fTable=updateFingerTable(std::stoi(request_put.value()),configData.chordserverport);
                    std::cout<<"My port number "<<configData.chordserverport<<" Nxt server "<<fTable.table[0]<<" Predecessor "<<fTable.predecessor<<std::endl;
                    reply_.set_value("Success");
                    reply_.set_key("success");
                }
                else if(request_get.key()!="")
                {
                    new CallDataLRU(service_, cq_, 0);
                    if(request_get.key().size()>256)
                    {
                        reply_.set_key(request_get.key());
                        reply_.set_value("Error key size long...");
                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Not Estable\n";
                        serverHandle << "Error key size long...\n";
                        serverHandle.close();
                    } else {
                        std::string requested_key = request_get.key();
                        std::pair <std::string, std::string> fetched_key_value = get_value(requested_key);

                        reply_.set_key(fetched_key_value.first);
                        reply_.set_value(fetched_key_value.second);

                        // i m get service...
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Estable\n";
                        serverHandle << "Method GET Parameter "<<request_get.key()<<" Reply value :"<<reply_.key()<<" "<<reply_.value()<<"\n";
                        serverHandle.close();
                    }
                }
                else if(request_put.key()!="")
                {
                    new CallDataLRU(service_, cq_, 1);
                    if(request_put.key().size()>256 || request_put.key().size()>256 )
                    {
                        reply_.set_key(request_put.key());
                        reply_.set_value("Error key size long...");
                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Not Estable\n";
                        serverHandle << "Error key or value size long...\n";
                        serverHandle.close();
                    }
                    else {

                        std::string requested_key = request_put.key();
                        std::string requested_value = request_put.value();

                        put_key_value(requested_key, requested_value);

                        reply_.set_value("Success");
                        reply_.set_key(requested_key);
                        // i m put service...

                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Estable\n";
                        serverHandle << "Method PUT Parameter "<<request_put.key()<<" "<<request_put.value()<<" Reply value :"<<reply_.key()<<" "<<reply_.value();
                        serverHandle.close();
                    }
                }
                else if( request_del.key()!="" )
                {
                    new CallDataLRU(service_, cq_, 2);
                    if(request_del.key().size()>256)
                    {
                        reply_.set_key(request_get.key());
                        reply_.set_value("Error key size long...");
                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Not Estable\n";
                        serverHandle << "Error key size long...\n";
                        serverHandle.close();
                    }
                    else {
                        std::string requested_key = request_del.key();

                        if(delete_key_value(requested_key)==-1){
                            reply_.set_value("Unsuccess");
                        } else{
                            reply_.set_value("Success");
                        }
                        reply_.set_key(requested_key);

                        //server lock
                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Estable\n";
                        serverHandle << "Method GET Parameter "<<request_del.key()<<" Reply value :"<<reply_.key()<<" "<<reply_.value();
                        serverHandle.close();
                    }
                }


                // The actual processing.


                status_ = FINISH;

                responder_.Finish(reply_, Status::OK, this);
            }
            else {
                GPR_ASSERT(status_ == FINISH);
                // Once in the FINISH state, deallocate ourselves (CallData).
                delete this;
            }
        }

    private:
        // The means of communication with the gRPC runtime for an asynchronous
        // server.
        int type_of_request;
        KV::AsyncService* service_;
        // The producer-consumer queue where for asynchronous server notifications.
        ServerCompletionQueue* cq_;
        // Context for the rpc, allowing to tweak aspects of it such as the use
        // of compression, authentication, as well as to send metadata back to the
        // client.
        ServerContext ctx_;

        // What we get from the client.
        GetKeyRequest request_get;
        PutKeyRequest request_put;
        DelKeyRequest request_del;
        // What we send back to the client.
        keyvaluepackage::Reply reply_;

        // The means to get back to the client.
        ServerAsyncResponseWriter<keyvaluepackage::Reply> responder_;
        // Let's implement a tiny state machine with the following states.
        enum CallStatus { CREATE, PROCESS, FINISH };
        CallStatus status_;  // The current serving state.
    };

    // This can be run in multiple threads if needed.
    void HandleRpcsLRU(int idx) {
        // Spawn a new CallData instance to serve new clients.

        new CallDataLRU(&service_, cq_[idx].get(), 0);
        new CallDataLRU(&service_, cq_[idx].get(), 1);
        new CallDataLRU(&service_, cq_[idx].get(), 2);
        void* tag;  // uniquely identifies a request.
        bool ok;
        while (true) {
            // Block waiting to read the next event from the completion queue. The
            // event is uniquely identified by its tag, which in this case is the
            // memory address of a CallData instance.
            // The return value of Next should always be checked. This return value
            // tells us whether there is any kind of event or cq_ is shutting down.
            GPR_ASSERT(cq_[idx]->Next(&tag, &ok));
            GPR_ASSERT(ok);
            static_cast<CallDataLRU*>(tag)->Proceed();
        }
    }

    class CallDataLFU {
    public:
        CallDataLFU(KV::AsyncService * service, ServerCompletionQueue * cq, int type)
                : service_(service), responder_(&ctx_), cq_(cq), status_(CREATE)
        {
            type_of_request = type;
            // Invoke the serving logic right away.
            Proceed();

        }
        void Proceed() {
            if (status_ == CREATE) {
                // Make this instance progress to the PROCESS state.
                status_ = PROCESS;
                // As part of the initial CREATE state, we *request* that the system
                // start processing SayHello requests. In this request, "this" acts are
                // the tag uniquely identifying the request (so that different CallData
                // instances can serve different requests concurrently), in this case
                // the memory address of this CallData instance.
                if(type_of_request==0){
                    service_->RequestGET(&ctx_,&request_get,&responder_,cq_,cq_,this);
                }else if(type_of_request==1){
                    service_->RequestPUT(&ctx_,&request_put,&responder_,cq_,cq_,this);
                }else if(type_of_request==2){
                    service_->RequestDEL(&ctx_,&request_del,&responder_,cq_,cq_,this);
                }

            }
            else if (status_ == PROCESS) {
                // The actual processing.


                if(request_put.key()=="-1")
                {
                    //New Server is added and need of update a finger table
                    fTable=updateFingerTable(std::stoi(request_put.value()),configData.chordserverport);
                    std::cout<<"My port number "<<configData.chordserverport<<" Nxt server "<<fTable.table[0]<<" Predecessor "<<
                    fTable.predecessor<<std::endl;
                    reply_.set_value("Success");
                    reply_.set_key("success");
                }
                else if(request_get.key()!="")
                {
                    new CallDataLFU(service_, cq_, 0);
                    if(request_get.key().size()>256)
                    {
                        reply_.set_key(request_get.key());
                        reply_.set_value("Error key size long...");
                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Not Estable\n";
                        serverHandle << "Error key size long...\n";
                        serverHandle.close();
                    }
                    else {

                        // try to find in cache
                        auto it = keyFeqValue.find(request_get.key());
                        //Present into cache
                        if (it != keyFeqValue.end()) {
                            //lock require
                            std::unique_lock <std::mutex> lock(door);
                            std::pair<int, std::string> value = keyFeqValue[request_get.key()];
                            auto it1 = feqKeq.find({value.first, request_get.key()});
                            feqKeq.erase(it1);
                            keyFeqValue[request_get.key()] = {value.first + 1, value.second};
                            feqKeq.insert({value.first + 1, request_get.key()});
                            reply_.set_value(value.second);
                            reply_.set_key(request_get.key());
                        }
                        else {//don't present into cache
                            std::unique_lock <std::mutex> lock(door);

                            std::pair<std::string, std::string> returnVal=get_from_file(file_name,request_get.key());
                            if(returnVal.first=="NULL") {
                                reply_.set_value("NOT FOUND");
                            }
                            else
                            {
                                reply_.set_value(returnVal.second);
                            }
                            reply_.set_key(request_get.key());
                        }

                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Estable\n";
                        serverHandle << "Method GET Parameter "<<request_get.key()<<" Reply value :"<<reply_.key()<<" "<<reply_.value()<<"\n";
                        serverHandle.close();
                    }
                }
                else if(request_put.key()!="")
                {
                    new CallDataLFU(service_, cq_, 1);
                    if(request_put.key().size()>256 || request_put.key().size()>256 )
                    {
                        reply_.set_key(request_put.key());
                        reply_.set_value("Error key size long...");
                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Not Estable\n";
                        serverHandle << "Error key or value size long...\n";
                        serverHandle.close();
                    }
                    else {

                        // i m put service...
                        auto it = keyFeqValue.find(request_put.key());
                        //Present into cache
                        if (it != keyFeqValue.end()) {
                            std::unique_lock <std::mutex> lock(door);
                            std::pair<int, std::string> value = keyFeqValue[request_put.key()];
                            auto it1 = feqKeq.find({value.first, request_put.key()});
                            feqKeq.erase(it1);

                            keyFeqValue[request_put.key()] = {value.first + 1, request_put.value()};

                            feqKeq.insert({value.first + 1, request_put.key()});

                            put_to_file(file_name,request_put.key(),request_put.value());
                        }
                        else {
                            std::unique_lock <std::mutex> lock(door);
                            keyFeqValue[request_put.key()] = {1, request_put.value()};
                            feqKeq.insert({1, request_put.key()});

                            put_to_file(file_name,request_put.key(),request_put.value());
                            if (feqKeq.size() > NUM_OF_RECORD) {
                                auto it = feqKeq.begin();
                                keyFeqValue.erase(it->second);
                                feqKeq.erase(it);
                            }
                        }
                        reply_.set_value("Success");
                        reply_.set_key(request_put.key());
                        //logic of file update

                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Estable\n";
                        serverHandle << "Method PUT Parameter "<<request_put.key()<<" "<<request_put.value()<<" Reply value :"<<reply_.key()<<" "<<reply_.value();
                        serverHandle.close();
                    }
                }
                else if(request_del.key()!="")
                {
                    new CallDataLFU(service_, cq_, 2);
                    if(request_del.key().size()>256)
                    {
                        reply_.set_key(request_get.key());
                        reply_.set_value("Error key size long...");
                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Not Estable\n";
                        serverHandle << "Error key size long...\n";
                        serverHandle.close();
                    }
                    else {
                        auto it = keyFeqValue.find(request_del.key());
                        //Present into cache
                        if (it != keyFeqValue.end()) {
                            //lock require
                            std::unique_lock <std::mutex> lock(door);
                            std::pair<int, std::string> value = keyFeqValue[request_del.key()];
                            keyFeqValue.erase(request_del.key());
                            auto it1 = feqKeq.find({value.first, request_del.key()});
                            feqKeq.erase(it1);

                            if(del_from_file(file_name,request_del.key())==0){
                                reply_.set_value("delete Success");
                            } else
                            {
                                reply_.set_value("delete Unsccess");
                            }
                        }
                        else
                        {
                            std::unique_lock <std::mutex> lock(door);


                            if(del_from_file(file_name,request_del.key())==0){
                                reply_.set_value("delete Success");
                            } else
                            {
                                reply_.set_value("delete Unsccess");
                            }
                        }

                        reply_.set_key(request_del.key());

                        std::unique_lock <std::mutex> lock(serverlck);
                        std::ofstream serverHandle("serverLog.txt", std::ios_base::app);
                        serverHandle << "Connection Estable\n";
                        serverHandle << "Method GET Parameter "<<request_del.key()<<" Reply value :"<<reply_.key()<<" "<<reply_.value();
                        serverHandle.close();
                    }
                }

                status_ = FINISH;

                responder_.Finish(reply_, Status::OK, this);
            }
            else {
                GPR_ASSERT(status_ == FINISH);
                // Once in the FINISH state, deallocate ourselves (CallData).
                delete this;
            }
        }

    private:
        // The means of communication with the gRPC runtime for an asynchronous
        // server.
        int type_of_request;
        KV::AsyncService* service_;
        // The producer-consumer queue where for asynchronous server notifications.
        ServerCompletionQueue* cq_;
        // Context for the rpc, allowing to tweak aspects of it such as the use
        // of compression, authentication, as well as to send metadata back to the
        // client.
        ServerContext ctx_;

        // What we get from the client.
        GetKeyRequest request_get;
        PutKeyRequest request_put;
        DelKeyRequest request_del;
        // What we send back to the client.
        keyvaluepackage::Reply reply_;

        // The means to get back to the client.
        ServerAsyncResponseWriter<keyvaluepackage::Reply> responder_;
        // Let's implement a tiny state machine with the following states.
        enum CallStatus { CREATE, PROCESS, FINISH };
        CallStatus status_;  // The current serving state.
    };

    // This can be run in multiple threads if needed.
    void HandleRpcsLFU(int idx) {
        // Spawn a new CallData instance to serve new clients.
        new CallDataLFU(&service_, cq_[idx].get(), 0);
        new CallDataLFU(&service_, cq_[idx].get(), 1);
        new CallDataLFU(&service_, cq_[idx].get(), 2);
        void* tag;  // uniquely identifies a request.
        bool ok;
        while (true) {
            // Block waiting to read the next event from the completion queue. The
            // event is uniquely identified by its tag, which in this case is the
            // memory address of a CallData instance.
            // The return value of Next should always be checked. This return value
            // tells us whether there is any kind of event or cq_ is shutting down.
            GPR_ASSERT(cq_[idx]->Next(&tag, &ok));
            GPR_ASSERT(ok);

            static_cast<CallDataLFU*>(tag)->Proceed();
        }
    }
    std::vector<std::unique_ptr<ServerCompletionQueue>> cq_;
    KV::AsyncService service_;
    std::unique_ptr<Server> server_;
};
int main(int argc, char** argv) {

    //struct configData contain data of config file
    configData = print(1);
    ServerImpl server;
    server.Run();

    return 0;
}