//
//#include <fstream>
//#include "unistd.h"
//#include <iostream>
//#include <memory>
//#include <string>
//#include <grpc/support/log.h>
//#include <grpcpp/grpcpp.h>
//#include <thread>
//
//#include "keyvaluepackage.grpc.pb.h"
//#include <chrono>
//#include <ctime>
//
//using grpc::Channel;
//using grpc::ClientAsyncResponseReader;
//using grpc::ClientContext;
//using grpc::CompletionQueue;
//using grpc::Status;
//using keyvaluepackage::KV;
//using keyvaluepackage::GetKeyRequest;
//using keyvaluepackage::Reply;
//using keyvaluepackage::PutKeyRequest;
//using keyvaluepackage::DelKeyRequest;
//std::fstream myfile;
//
//class GreeterClient {
//public:
//    explicit GreeterClient(std::shared_ptr <Channel> channel)
//            : stub_(KV::NewStub(channel)) {}
//    void GET(const std::string& k)
//    {
//        GetKeyRequest request;
//        request.set_key(k);
//
//        AsyncClientCall* call = new AsyncClientCall;
//
//        call->response_reader = stub_->PrepareAsyncGET(&call->context,request,&cq_);
//        call->response_reader->StartCall();
//        call->response_reader->Finish(&call->reply,&call->status,(void *)call);
//
//        return;
//    }
//    void PUT(const std::string& k,const std::string& k2)
//    {
//        PutKeyRequest request;
//        request.set_key(k);
//        request.set_value(k2);
//        AsyncClientCall* call = new AsyncClientCall;
//
//        call->response_reader = stub_->PrepareAsyncPUT(&call->context,request,&cq_);
//        call->response_reader->StartCall();
//        call->response_reader->Finish(&call->reply,&call->status,(void *)call);
//
//
//    }
//    void DEL(const std::string& k)
//    {
//        DelKeyRequest request;
//        request.set_key(k);
//
//        AsyncClientCall* call = new AsyncClientCall;
//
//        call->response_reader = stub_->PrepareAsyncDEL(&call->context,request,&cq_);
//        call->response_reader->StartCall();
//        call->response_reader->Finish(&call->reply,&call->status,(void *)call);
//
//
//    }
//    void AsyncCompleteRpc() {
//        void* got_tag;
//        bool ok = false;
//
//        // Block until the next result is available in the completion queue "cq".
//        while (cq_.Next(&got_tag, &ok)) {
//            // The tag in this example is the memory location of the call object
//            AsyncClientCall* call = static_cast<AsyncClientCall*>(got_tag);
//
//            // Verify that the request was completed successfully. Note that "ok"
//            // corresponds solely to the request for updates introduced by Finish().
//            GPR_ASSERT(ok);
//
//            if (call->status.ok()==false)
//            {
//                std::cout << "RPC failed" << std::endl;
//            } else
//            {
//                std::cout<<"Success"<<std::endl;
//            }
//
//            // Once we're complete, deallocate the call object.
//            delete call;
//        }
//    }
//private:
//    // struct for keeping state and data information
//    struct AsyncClientCall {
//        // Container for the data we expect from the server.
//        keyvaluepackage::Reply reply;
//
//        // Context for the client. It could be used to convey extra information to
//        // the server and/or tweak certain RPC behaviors.
//        ClientContext context;
//
//        // Storage for the status of the RPC upon completion.
//        Status status;
//
//        std::unique_ptr<ClientAsyncResponseReader<keyvaluepackage::Reply>> response_reader;
//    };
//
//
//    // Out of the passed in Channel comes the stub, stored here, our view of the
//    // server's exposed services.
//    std::unique_ptr<KV::Stub> stub_;
//
//    // The producer-consumer queue we use to communicate asynchronously with the
//    // gRPC runtime.
//    CompletionQueue cq_;
//};
//int main(int argc, char** argv) {
//    std::string s1,s2,user;
//    std::cout<<"Enter a server port Number"<<std::endl;
//    std::cin>>s1;
//    GreeterClient greeter(grpc::CreateChannel(
//            "localhost:"+s1, grpc::InsecureChannelCredentials()));
//    std::thread thread = std::thread(&GreeterClient::AsyncCompleteRpc, &greeter);
//
//    std::string a;
//    //start
//
//    while (std::cin>>a)
//    {
//        std::cout<<"1 For get"<<std::endl;
//        std::cout<<"2 For put"<<std::endl;
//        std::cout<<"3 For del"<<std::endl;
//
//        if(a=="1")
//        {
//            std::cin>>user;
//            greeter.GET(user);
//        } else if(a=="2")
//        {
//            std::cin>>s1>>s2;
//            greeter.PUT(s1,s2);
//        } else if(a=="3")
//        {
//            std::cin>>s1;
//            greeter.DEL(s1);
//        } else
//        {
//            std::cout<<"Please  start a client again(Ctrl + C) and give a valid input"<<std::endl;
//            break;
//        }
//
//    }
//    thread.join();
//
//    return 0;
//}
#include "KVServerClient.h"
#include <bits/stdc++.h>
#include "mutex"
#include "vector"
#include "helper.h"
#include "unistd.h"
#include <iostream>
#include <memory>
#include <string>
#include <thread>
#include "unordered_map"
#include <grpc/support/log.h>
#include <grpcpp/grpcpp.h>
#include "unordered_map"
#include "utility"
#include "keyvaluepackage.grpc.pb.h"
#include <iterator>
#include <set>
#include <list>
#include <fstream>
using grpc::Server;
using grpc::ServerAsyncResponseWriter;
using grpc::ServerBuilder;
using grpc::ServerCompletionQueue;
using grpc::ServerContext;
using grpc::Status;
using keyvaluepackage::KV;
using keyvaluepackage::GetKeyRequest;
using keyvaluepackage::Reply;
using keyvaluepackage::PutKeyRequest;
using keyvaluepackage::DelKeyRequest;

struct conf configData;
class ServerImpl final {
public:
    ~ServerImpl() {
        server_->Shutdown();
        // Always shutdown the completion queue after the server.
        cq_[0]->Shutdown();
    }
    void Run() {
        std::cout<<"Enter a server port Number"<<std::endl;
        configData=print(2);
        std::string server_address("0.0.0.0:"+ std::to_string(configData.clientlistenport));
        ServerBuilder builder;
        // Listen on the given address without any authentication mechanism.
        builder.AddListeningPort(server_address, grpc::InsecureServerCredentials());
        // Register "service_" as the instance through which we'll communicate with
        // clients. In this case it corresponds to an *asynchronous* service.
        builder.RegisterService(&service_);
        // Get hold of the completion queue used for the asynchronous communication
        // with the gRPC runtime.
        cq_.push_back( builder.AddCompletionQueue());

        // Finally assemble the server.
        server_ = builder.BuildAndStart();
        std::cout << "Server listening on" << server_address << std::endl;

        // Proceed to the server's main loop.
        HandleRpcsLFU();
    }
private:


    // This can be run in multiple threads if needed.

    class CallDataLFU {
    public:
        CallDataLFU(KV::AsyncService * service, ServerCompletionQueue * cq)
                : service_(service), responder_(&ctx_), cq_(cq), status_(CREATE)
        {
            // Invoke the serving logic right away.
            Proceed();

        }
        void Proceed() {
            if (status_ == CREATE) {
                // Make this instance progress to the PROCESS state.
                status_ = PROCESS;
                // As part of the initial CREATE state, we *request* that the system
                // start processing SayHello requests. In this request, "this" acts are
                // the tag uniquely identifying the request (so that different CallData
                // instances can serve different requests concurrently), in this case
                // the memory address of this CallData instance.

                service_->RequestPUT(&ctx_,&request_put,&responder_,cq_,cq_,this);


            }
            else if (status_ == PROCESS) {
                new CallDataLFU(service_,cq_);
                // The actual processing.
                std::cout<<request_put.key()<<" "<<request_put.value()<<std::endl;
                reply_.set_value("success");
                status_ = FINISH;

                responder_.Finish(reply_, Status::OK, this);

            }
            else {
                GPR_ASSERT(status_ == FINISH);
                // Once in the FINISH state, deallocate ourselves (CallData).
                delete this;
            }
        }

    private:
        // The means of communication with the gRPC runtime for an asynchronous
        // server.
        int type_of_request;
        KV::AsyncService* service_;
        // The producer-consumer queue where for asynchronous server notifications.
        ServerCompletionQueue* cq_;
        // Context for the rpc, allowing to tweak aspects of it such as the use
        // of compression, authentication, as well as to send metadata back to the
        // client.
        ServerContext ctx_;

        // What we get from the client.
        PutKeyRequest request_put;
        // What we send back to the client.
        keyvaluepackage::Reply reply_;

        // The means to get back to the client.
        ServerAsyncResponseWriter<keyvaluepackage::Reply> responder_;
        // Let's implement a tiny state machine with the following states.
        enum CallStatus { CREATE, PROCESS, FINISH };
        CallStatus status_;  // The current serving state.
    };

    // This can be run in multiple threads if needed.
    void HandleRpcsLFU() {
        // Spawn a new CallData instance to serve new clients.
        new CallDataLFU(&service_, cq_[0].get());
        void* tag;  // uniquely identifies a request.
        bool ok;
        std::cout<<"Enter a chord server port number"<<std::endl;
        std::string port,s1,s2="a";
        std::cin>>port;
        int z,i=0;
        while (true) {
            if(i==0) {
                while (true) {
                    std::cin >> z;
                    if (z == 1) {
                        std::cin >> s1;
                        break;
                    } else if (z == 2) {
                        std::cin >> s1 >> s2;
                        break;
                    } else if (z == 3) {
                        std::cin >> s1;
                        break;
                    } else
                    {
                        std::cout<<"Enter a correct request"<<std::endl;
                    }
                }
                connectNxt(z, port, s1, s2);
            }
            i=1-i;
            // Block waiting to read the next event from the completion queue. The
            // event is uniquely identified by its tag, which in this case is the
            // memory address of a CallData instance.
            // The return value of Next should always be checked. This return value
            // tells us whether there is any kind of event or cq_ is shutting down.
            GPR_ASSERT(cq_[0]->Next(&tag, &ok));
            GPR_ASSERT(ok);
            static_cast<CallDataLFU*>(tag)->Proceed();
        }
    }
    std::vector<std::unique_ptr<ServerCompletionQueue>> cq_;
    KV::AsyncService service_;
    std::unique_ptr<Server> server_;
};
int main(int argc, char** argv) {

    //struct configData contain data of config file
    ServerImpl server;
    server.Run();

    return 0;
}