#include <fstream>
#include "unistd.h"
#include <iostream>
#include <memory>
#include <string>
#include <grpc/support/log.h>
#include <grpcpp/grpcpp.h>
#include <thread>

#include "keyvaluepackage.grpc.pb.h"
#include <chrono>
#include <ctime>
#include "KVServerClient.h"
using grpc::Channel;
using grpc::ClientAsyncResponseReader;
using grpc::ClientContext;
using grpc::CompletionQueue;
using grpc::Status;
using keyvaluepackage::KV;
using keyvaluepackage::GetKeyRequest;
using keyvaluepackage::Reply;
using keyvaluepackage::PutKeyRequest;
using keyvaluepackage::DelKeyRequest;

class GreeterClient {
public:
    explicit GreeterClient(std::shared_ptr <Channel> channel)
            : stub_(KV::NewStub(channel)) {}
    void GET(const std::string& k)
    {
        GetKeyRequest request;
        request.set_key(k);

        AsyncClientCall* call = new AsyncClientCall;

        call->response_reader = stub_->PrepareAsyncGET(&call->context,request,&cq_);
        call->response_reader->StartCall();
        call->response_reader->Finish(&call->reply,&call->status,(void *)call);
        void* got_tag;
        bool ok = false;

        // Block until the next result is available in the completion queue "cq".
        GPR_ASSERT(cq_.Next(&got_tag, &ok));
        // The tag in this example is the memory location of the call object
        call = static_cast<AsyncClientCall*>(got_tag);

        // Verify that the request was completed successfully. Note that "ok"
        // corresponds solely to the request for updates introduced by Finish().
        GPR_ASSERT(ok);

        if (call->status.ok()==false)
        {
            std::cout << "RPC failed" << std::endl;
        } else
        {
            std::cout<<"Success"<<std::endl;
        }
        return;
    }
    void PUT(const std::string& k,const std::string& k2)
    {
        PutKeyRequest request;
        request.set_key(k);
        request.set_value(k2);
        AsyncClientCall* call = new AsyncClientCall;

        call->response_reader = stub_->PrepareAsyncPUT(&call->context,request,&cq_);
        call->response_reader->StartCall();
        call->response_reader->Finish(&call->reply,&call->status,(void *)call);
        void* got_tag;
        bool ok = false;

        // Block until the next result is available in the completion queue "cq".
        GPR_ASSERT(cq_.Next(&got_tag, &ok));
        // The tag in this example is the memory location of the call object
        call = static_cast<AsyncClientCall*>(got_tag);

        // Verify that the request was completed successfully. Note that "ok"
        // corresponds solely to the request for updates introduced by Finish().
        GPR_ASSERT(ok);

        if (call->status.ok()==false)
        {
            std::cout << "RPC failed" << std::endl;
        } else
        {
            std::cout<<"Success"<<std::endl;
        }
        return;

    }
    void DEL(const std::string& k)
    {
        DelKeyRequest request;
        request.set_key(k);

        AsyncClientCall* call = new AsyncClientCall;

        call->response_reader = stub_->PrepareAsyncDEL(&call->context,request,&cq_);
        call->response_reader->StartCall();
        call->response_reader->Finish(&call->reply,&call->status,(void *)call);
        void* got_tag;
        bool ok = false;

        // Block until the next result is available in the completion queue "cq".
        GPR_ASSERT(cq_.Next(&got_tag, &ok));
        // The tag in this example is the memory location of the call object
        call = static_cast<AsyncClientCall*>(got_tag);

        // Verify that the request was completed successfully. Note that "ok"
        // corresponds solely to the request for updates introduced by Finish().
        GPR_ASSERT(ok);

        if (call->status.ok()==false)
        {
            std::cout << "RPC failed" << std::endl;
        } else
        {
            std::cout<<"Success"<<std::endl;
        }
        return;

    }
    void AsyncCompleteRpc() {
        void* got_tag;
        bool ok = false;

        // Block until the next result is available in the completion queue "cq".
        cq_.Next(&got_tag, &ok);
            // The tag in this example is the memory location of the call object
            AsyncClientCall* call = static_cast<AsyncClientCall*>(got_tag);

            // Verify that the request was completed successfully. Note that "ok"
            // corresponds solely to the request for updates introduced by Finish().
            GPR_ASSERT(ok);

            if (call->status.ok()==false)
            {
                std::cout << "RPC failed" << std::endl;
            } else
            {
                std::cout<<"Success"<<std::endl;
            }

    }
private:
    // struct for keeping state and data information
    struct AsyncClientCall {
        // Container for the data we expect from the server.
        keyvaluepackage::Reply reply;

        // Context for the client. It could be used to convey extra information to
        // the server and/or tweak certain RPC behaviors.
        ClientContext context;

        // Storage for the status of the RPC upon completion.
        Status status;

        std::unique_ptr<ClientAsyncResponseReader<keyvaluepackage::Reply>> response_reader;
    };


    // Out of the passed in Channel comes the stub, stored here, our view of the
    // server's exposed services.
    std::unique_ptr<KV::Stub> stub_;

    // The producer-consumer queue we use to communicate asynchronously with the
    // gRPC runtime.
    CompletionQueue cq_;
};
void connectNxt(int requestType,std::string port,std::string key ,std::string value) {

    GreeterClient greeter(grpc::CreateChannel(
            "localhost:"+port, grpc::InsecureChannelCredentials()));

    if(requestType==1)
    {
        greeter.GET(key);
    } else if(requestType==2)
    {
        greeter.PUT(key,value);
    } else if(requestType==3)
    {
        greeter.DEL(key);
    }

}

