# GIT
## Password issues
To avoid entering username and password everytime you pull/push to a git repository, there are two known ways.
* Add your SSH public key to the remote end (this is possible with either github, gitlab or a private remote server)
* Setup your `~/.gitconfig` like:
  ```
  # This is Git's per-user configuration file.
  [user]
        name = vihari
        email = viharipiratla@gmail.com
  [credential]
        helper = osxkeychain
  ```
  The `osxkeychain` works only on Mac and I use `/usr/share/doc/git/contrib/credential/gnome-keyring/git-credential-gnome-keyring` on Linux.
  For more: [refer](http://blog.iqandreas.com/git/storing-https-authentication-in-ubuntu-and-arch-linux/)

## Pulling and Pushing
Every git repository contains a folder called `.git` and `config` file in it which defines the url of the remote bare repository.
One can configure the file to add any other remote servers not listed on modify the existing one. 

Assuming that you have the repository configured, you can use `git pull origin master` for pulling any changes on master branch of origin repo. 
Similarly, `git push origin master` to push any changes on the local machine to remote server

## Branch creation and merging
Branches can fork the development and lets one work on a feature for a short duration without worrying about breaking the system.
### Creation

```
# list all the branches in this repo.
# the current branch is prefixed with '*' and is colored green
git branch
# create a branch
git branch <branch name>
# switch to a branch
git checkout <branch name>
# push the changes in a branch
git push origin <branch name>
```

### Merging
The following commands will merge the changes of master into a branch called `feature`.

`git chekout feature; git merge master`  
or  
`git merge master feature`

There are certain problems using git merge, whenever a branch is merged the log history is no more linear and makes it hard to understand it through git log.

Another way of merging two branches is through `git-rebase`. 
**The golden rule of git rebase is to never use it on public branches.**

`git checkout feature; git rebase master`  

Use the command above to also merge the changes but for a linear commit history. 
The changes will look as though feature is developed on the tip of master;
Refer [Tutorial](https://www.atlassian.com/git/tutorials/merging-vs-rebasing/summary)

## Revert/Reset
If you want to revert a commit or just want to reset the code base, the use: `git reset --hard <commit-id>`.
`commit-id` is the commit id of the commit that you want to reset to.
This command should be used with caution, since it nullifies all the changes in the working directory.

Use `--soft` instead of `--hard` is you want to keep the changes to the files, but want to remove some commits in the history.

## Misc
`git log` shows the log messages and `git log -p` displays the files changed and the changes with each commit.

## View the files changed

`git diff --name-only --diff-filter=U`  
will list all the modified files, if you wish to also see the change summary along with the files then use
`git diff --diff-filter=U`  
http://stackoverflow.com/questions/3065650/whats-the-simplest-way-to-git-a-list-of-conflicted-files

`git diff --cached`  
To view all the changes staged for commit.

## Submodules (Advanced)
Through submodules, we can add dependency from the current project to any other git project.

`git submodule sync`  
When the path to a gitmodue is changed in `.gitmodule` then use this command for the changes to be reflected in the .git/conf file.  
`git submodule update --recursive --remote`  
Updates the submodules -- http://stackoverflow.com/questions/1030169/easy-way-pull-latest-of-all-submodules
`git submodule update --init --recursive`
Pulls all the content in all the submodules of the repository, use `init` when you are doing it for the first time -- http://stackoverflow.com/questions/1030169/easy-way-pull-latest-of-all-submodules

# Emacs [Domesticating the wild beast] 

**Moving to the next line: ** `ALT+[f/b]` http://stackoverflow.com/questions/2078855/about-the-forward-and-backward-a-word-behaviour-in-emacs
**Moving to a column: ** `ALT+x` and `move-to-colum #column` which is bound to `M-g TAB`.

## Org Mode [The feature that makes Emacs irresistable]
You can make presentations, tables, ToDo lists and export them to html, pdf, jkyll etc. with this.

# PERL [You never cease to amaze me]

# MISC [Linux Man! Linux]

`sort|uniq` is equivalent to `sort -u`

use cut(1) as `cut -d $D -f @F` instead of `perl -ane '@fs=split('$D');map {print $fs[$_]} @F'`

`[command] -- ` -- `rm -- -*`  
If you want to pass a parameter with - in it and not allow it to be treated as command line argument then just put -- at the arg list and any subsequent words will be treated as params.
In the example above, to remove all files in the dir that start with '-' use it like shown.

Set the command line history off with `set +o history` and on with: `set -o history`.  
Alternatively, if you want to completely disable history then: `unset HISTFILE`.

## cURL

Send form data using cURL with `curl -d 'param1=value1' -d 'param2=value2' URL`.  
A handy command: `curl -d "uname=P16495" -d "passwd=<pwd>" https://internet.iitb.ac.in/index.php` to login into internet at IITB. [do not bother about special chars like '@' in the password]

Use `-L` to handle redirects.

# JAVA

To write UTF-8 content into files use:  
`
Writer out = new BufferedWriter(new OutputStreamWriter(
    new FileOutputStream("outfilename"), "UTF-8"));
try {
    out.write(aString);
} finally {
    out.close();
}
`  

