import java.io.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;

public class StockExchange {


    public ArrayList<Transaction> run(ArrayList<String> inputStrings) throws IOException {

        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        Matcher matcher = new Matcher();
        boolean shouldContinue = true;

        ArrayList<Transaction> transactionList = new ArrayList<>();
        int inputIndex = 0;
        while (shouldContinue && inputIndex < inputStrings.size()) {
            // get/parse user input
            Transaction currentTransaction = new Transaction();
            System.out.println("New Transacrion: \"Time Quantity Price Customer_Id Stock Type\" ");
            String inputString = inputStrings.get(inputIndex);
            inputIndex++;
            currentTransaction = getTransaction(inputString);

            if (!transactionList.isEmpty()) {

                for (int i = 0; i < transactionList.size(); i++) {
                    Matcher.MatchType matchType = matcher.match(transactionList.get(i), currentTransaction);

                    if (matchType == Matcher.MatchType.FULL_MATCH) {
                        // modify ith transaction
                        transactionList.get(i).setQuantity(transactionList.get(i).getQuantity() - currentTransaction.getQuantity());
                        if (transactionList.get(i).getQuantity() == 0) {
                            transactionList.remove(i);
                        }
                        System.out.println(currentTransaction.getCustomerId() + " successfully traded " + transactionList.get(i).getQuantity() + " stocks with " + transactionList.get(i).getCustomerId());
                        break;
                    } else if (matchType == Matcher.MatchType.PARTIAL_MATCH) {
                        // modify current Transaction
                        // drop i'th transaction
                        currentTransaction.setQuantity(currentTransaction.getQuantity() - transactionList.get(i).getQuantity());
                        transactionList.remove(i);
                        System.out.println(currentTransaction.getCustomerId() + " successfully traded " + transactionList.get(i).getQuantity() + " stocks with " + transactionList.get(i).getCustomerId());

                    } else if (matchType == Matcher.MatchType.NO_MATCH) {
                        // move on
                    }
                    if (i == transactionList.size() - 1 && currentTransaction.getQuantity() > 0) {
                        transactionList.add(currentTransaction);
                        sortTransactions(transactionList);
                        break;
                    }


                }
            } else {
                // add this transaction if list is empty
                transactionList.add(currentTransaction);
                sortTransactions(transactionList);

//                System.out.print(transactionList);
            }

//            System.out.println("Do you want to continue? y|n");
//            String userResponseString = reader.readLine();
//            if (userResponseString.equals("n")) {
//                shouldContinue = false;
//            }
        }

        return transactionList;

    }

    public void sortTransactions(ArrayList<Transaction> transactionList) {
        Collections.sort(transactionList, new Comparator<Transaction>() {
            @Override
            public int compare(Transaction o1, Transaction o2) {
                if (o1.getTime() == o2.getTime()) {
                    return 0;
                } else if (o1.getTime() > o2.getTime()) {
                    return 1;
                } else {
                    return -1;
                }
            }
        });
    }

    public Transaction getTransaction(String inputString) {
        Transaction currentTransaction = new Transaction();
        StringTokenizer stringTokenizer = new StringTokenizer(inputString);
        if (stringTokenizer.hasMoreTokens()) {
            currentTransaction.setTime(Integer.parseInt(stringTokenizer.nextToken()));
            currentTransaction.setQuantity(Integer.parseInt(stringTokenizer.nextToken()));
            currentTransaction.setPricePerUnit(Float.parseFloat(stringTokenizer.nextToken()));
            currentTransaction.setCustomerId(stringTokenizer.nextToken());
            currentTransaction.setStock(stringTokenizer.nextToken());
            currentTransaction.setTypeOfRequest(stringTokenizer.nextToken());
        }
        return currentTransaction;
    }
}
