import java.util.Comparator;
import java.util.Objects;

public class Transaction {

    private int time;
    private int quantity;
    private float pricePerUnit;
    private String customerId;
    private String stock;
    private String typeOfRequest;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Transaction that = (Transaction) o;
        return time == that.time &&
                quantity == that.quantity &&
                Float.compare(that.pricePerUnit, pricePerUnit) == 0 &&
                Objects.equals(customerId, that.customerId) &&
                Objects.equals(stock, that.stock) &&
                Objects.equals(typeOfRequest, that.typeOfRequest);
    }

    @Override
    public int hashCode() {

        return Objects.hash(time, quantity, pricePerUnit, customerId, stock, typeOfRequest);
    }

    public int getTime() {
        return time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getQuantity() {
        return quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public float getPricePerUnit() {
        return pricePerUnit;
    }

    public void setPricePerUnit(float pricePerUnit) {
        this.pricePerUnit = pricePerUnit;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getStock() {
        return stock;
    }

    public void setStock(String stock) {
        this.stock = stock;
    }

    public String getTypeOfRequest() {
        return typeOfRequest;
    }

    public void setTypeOfRequest(String typeOfRequest) {
        this.typeOfRequest = typeOfRequest;
    }

    @Override
    public String toString() {
        return "Transaction{" +
                "time=" + time +
                ", quantity=" + quantity +
                ", pricePerUnit=" + pricePerUnit +
                ", customerId='" + customerId + '\'' +
                ", stock='" + stock + '\'' +
                ", typeOfRequest='" + typeOfRequest + '\'' +
                '}';
    }


}
