import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.io.IOException;
import java.util.ArrayList;

import static org.junit.Assert.*;

public class StockExchangeTest {

    private StockExchange stockExchange;

    @Before
    public void setUp() throws Exception {
        stockExchange = new StockExchange();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void run() throws IOException {
        ArrayList<String> testStrings = new ArrayList<String>();
        testStrings.add("1 20 300 C8 Apple Sell");
        testStrings.add("10 35 200 C9 Moto Buy");
        testStrings.add("9 20 400 C5 Jio Sell");
        testStrings.add("7 30 300 C7 Moto Sell");
        testStrings.add("8 20 250 C7 Moto Buy");
        testStrings.add("2 25 400 C6 Jio Buy");
        testStrings.add("12 25 400 C6 Apple Buy");


        ArrayList<Transaction> actualList = new ArrayList<>();
//        actualList.add(stockExchange.getTransaction("1 20 300 C8 Apple Sell"));
        actualList.add(stockExchange.getTransaction("2 5 400 C6 Jio Buy"));
        actualList.add(stockExchange.getTransaction("7 30 300 C7 Moto Sell"));
        actualList.add(stockExchange.getTransaction("8 20 250 C7 Moto Buy"));
        actualList.add(stockExchange.getTransaction("10 35 200 C9 Moto Buy"));
        actualList.add(stockExchange.getTransaction("12 5 400 C6 Apple Buy"));

        ArrayList<Transaction> resultList = stockExchange.run(testStrings);
        for (int i = 0; i < resultList.size(); i++) {
            assertEquals(resultList.get(i), actualList.get(i));
        }
    }
}