import java.io.*;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StockExchange {


    public void run() throws IOException {

        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        Matcher matcher = new Matcher();
        boolean shouldContinue = true;

        ArrayList<Transaction> transactionList = new ArrayList<>();

        while (shouldContinue) {
            // get/parse user input
            Transaction currentTransaction = new Transaction();
            System.out.println("New Transacrion: \"Time Quantity Price Customer_Id Stock Type\" ");
            String inputString = reader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(inputString);
            if (stringTokenizer.hasMoreTokens()) {
                currentTransaction.setTime(Integer.parseInt(stringTokenizer.nextToken()));
                currentTransaction.setQuantity(Integer.parseInt(stringTokenizer.nextToken()));
                currentTransaction.setPricePerUnit(Float.parseFloat(stringTokenizer.nextToken()));
                currentTransaction.setCustomerId(stringTokenizer.nextToken());
                currentTransaction.setStock(stringTokenizer.nextToken());
                currentTransaction.setTypeOfRequest(stringTokenizer.nextToken());
            }

            if (!transactionList.isEmpty()) {

                for (int i = 0; i < transactionList.size(); i++) {
                    Matcher.MatchType matchType = matcher.match(transactionList.get(i), currentTransaction);

                    if (matchType == Matcher.MatchType.FULL_MATCH) {
                        // modify ith transaction
                        transactionList.get(i).setQuantity(transactionList.get(i).getQuantity() - currentTransaction.getQuantity() );
                        if(transactionList.get(i).getQuantity() == 0){
                            transactionList.remove(i);
                        }
                        System.out.println(currentTransaction.getCustomerId()+" successfully traded "+ transactionList.get(i).getQuantity()+" stocks with "+transactionList.get(i).getCustomerId());
                        break;
                    } else if (matchType == Matcher.MatchType.PARTIAL_MATCH) {
                        // modify current Transaction
                        // drop i'th transaction
                        currentTransaction.setQuantity(currentTransaction.getQuantity() - transactionList.get(i).getQuantity());
                        transactionList.remove(i);
                        System.out.println(currentTransaction.getCustomerId()+" successfully traded "+ transactionList.get(i).getQuantity()+" stocks with "+transactionList.get(i).getCustomerId());

                    } else if (matchType == Matcher.MatchType.NO_MATCH) {
                        // move on
                        continue;
                    }
                    if(i == transactionList.size()-1 && currentTransaction.getQuantity() > 0) {
                        transactionList.add(currentTransaction);


                    }


                }
            } else {
                // add this transaction if list is empty
                transactionList.add(currentTransaction);
            }

            System.out.println("Do you want to continue? y|n");
            String userResponseString = reader.readLine();
            if (userResponseString.equals("n")) {
                shouldContinue = false;
            }
        }



    }
}
