public class Matcher {

    public enum MatchType {FULL_MATCH, PARTIAL_MATCH, NO_MATCH}


    public MatchType match(Transaction t1, Transaction t2) {

        if (t1.getCustomerId().equals(t2.getCustomerId())) {
            return MatchType.NO_MATCH;
        }

        if (!t1.getStock().equals(t2.getStock())) {
            return MatchType.NO_MATCH;
        }
        if (!t1.getTypeOfRequest().equals(t2.getTypeOfRequest())) {
            return MatchType.NO_MATCH;
        }
        //current trans is sell
        if (t1.getTypeOfRequest().equals("Buy") && t2.getTypeOfRequest().equals("Sell")) {
            if (t1.getPricePerUnit() < t2.getPricePerUnit()) {
                return MatchType.NO_MATCH;
            }
            //selling quantity of current transaction exhausts
            else{
                if(t2.getQuantity() <= t1.getQuantity()){
                    return MatchType.FULL_MATCH;
                }
                else{
                    return MatchType.PARTIAL_MATCH;
                }
            }
        }
        // current trans is buy
        else{
            if(t1.getPricePerUnit() > t2.getPricePerUnit()){
                return MatchType.NO_MATCH;
            }
            // buying quantity of current trans exhausts
            else {
                if(t2.getQuantity() <= t1.getQuantity()){
                    return MatchType.FULL_MATCH;
                }
                else {
                    return MatchType.PARTIAL_MATCH;
                }
            }
        }

    }
}