from django.shortcuts import render
from django.shortcuts import redirect
from django.contrib.auth.models import User
import numpy as np
from .models import Post , Tags , alpha , total 
from django.db.models import Q
def sampling(sl,tl):
	e = np.zeros(len(sl))
	length =len(sl)
	count = 0
	while count<length:
		e[count] = np.random.beta(sl[count]+1,tl[count]-sl[count]+1)
		count += 1 
	top1 = np.argmax(e)
	e[top1] = 0
	top2 = np.argmax(e)
	e[top2] = 0
	top3 = np.argmax(e)
	return top1 , top2 , top3

def home(request):
	if request.user.is_authenticated:
		success = alpha.objects.get(userid = request.user)
		timeperiod = total.objects.get(userid = request.user)
		sl = [ success.ML , success.RL , success.DIP , success.MATHS , 
		 success.python , success.physics ,success.chemistry, success.computer_science , success.arts , 
		 success.geography , success.architecture , success.engineering , success.literature   ]
		tl = [ timeperiod.ML , timeperiod.RL , timeperiod.DIP , timeperiod.MATHS  , 
		 timeperiod.python , timeperiod.physics , timeperiod.chemistry , timeperiod.computer_science , timeperiod.arts , 
		 timeperiod.geography , timeperiod.architecture , timeperiod.engineering , timeperiod.literature]
		action1 ,action2 , action3 = sampling(sl,tl)
		post1 = Post.objects.filter(tags=action1+6).order_by('-pk')[:3]
		post2 = Post.objects.filter(tags=action2+6).order_by('-pk')[:2]
		post3 = Post.objects.filter(tags=action3+6).order_by('-pk')[:1]
		post11 = Post.objects.filter(tags=action1+6).order_by('-pk')[3:]
		post12 = Post.objects.filter(tags=action2+6).order_by('-pk')[2:]
		post13 = Post.objects.filter(tags=action3+6).order_by('-pk')[1:]
		post = Post.objects.filter(~Q(tags = action1+6) & ~Q(tags=action2+6) &
		 ~Q(tags=action3+6)).order_by('-pk')
		#...............UPDATING TOTAL VALUE OF ALL THE POSTS.......
		#>>> product = Product.objects.get(name='Venezuelan Beaver Cheese')
		#>>> product.number_sold += 1
		#>>> product.save()
		timeperiod.ML +=1
		timeperiod.RL +=1
		timeperiod.DIP +=1
		timeperiod.MATHS +=1
		timeperiod.python +=1
		timeperiod.physics +=1
		timeperiod.chemistry +=1
		timeperiod.computer_science +=1
		timeperiod.arts +=1
		timeperiod.geography +=1
		timeperiod.architecture +=1
		timeperiod.engineering +=1
		timeperiod.literature +=1
		timeperiod.save()
		return render(request , 'home.html' , {'post1' : post1 , 'post2' : post2 , 'post3' : post3 ,
		 'post11' : post11 , 'post12' : post12 , 'post13' : post13, 'post':post})
	else:
		post = Post.objects.all().order_by('-pk')
		return render(request , 'home.html' , {'post' : post})

def detail(request , pk):
	if request.user.is_authenticated:
		postdetail = Post.objects.get(pk=pk)
		success = alpha.objects.get(userid = request.user)
		timeperiod = total.objects.get(userid = request.user)
		tag = postdetail.tags
		# print(type(7))
		if tag == 6:
			success.ML +=1
			timeperiod.ML +=1
		elif tag == 7:
			success.RL +=1
			timeperiod.RL +=1
		elif tag == 8:
			success.DIP +=1
			timeperiod.DIP += 1
		elif tag == 9:
			success.MATHS +=1
			timeperiod.MATHS += 1
		elif tag == 10:
			success.python +=1
			timeperiod.python += 1
		elif tag == 11:
			success.physics +=1
			timeperiod.physics += 1
		elif tag == 12:
			success.chemistry +=1
			timeperiod.chemistry += 1
		elif tag == 13:
			success.computer_science +=1
			timeperiod.computer_science += 1
		elif tag == 14:
			success.arts +=1
			timeperiod.arts += 1
		elif tag == 15:
			success.geography +=1
			timeperiod.geography += 1
		elif tag == 16:
			success.architecture +=1
			timeperiod.architecture += 1
		elif tag == 17:
			success.engineering +=1
			timeperiod.engineering += 1
		elif tag == 18:
			success.literature +=1
			timeperiod.literature += 1
		
		success.save()
		timeperiod.save()
		post = Post.objects.filter(tagname=postdetail.tagname).order_by('-pk')
		return render(request , 'post_detail.html' , {'postdetail' : postdetail, 'post':post})

	else:
		postdetail = Post.objects.get(pk=pk)
		post = Post.objects.filter(Q(tagname=postdetail.tagname) & ~Q(pk=postdetail.pk)).order_by('-pk')
		return render(request , 'post_detail.html' , {'postdetail' : postdetail, 'post':post})



def personalspace(request):
	tags = Tags.objects.all()
	post = Post.objects.all().filter(author=request.user).order_by('-pk')
	return render(request , 'personalspace.html' , {'post' : post , 'tags': tags})
def inputdata(request):
	if request.method == 'POST':
		tags = request.POST['tags'].strip()
		title = request.POST['title'].strip()
		body = request.POST['body'].strip()		
		thetag = Tags.objects.get(pk=tags)
		if len(tags) == 0 or len(title) == 0 or len(body)==0:
			return redirect('personalspace')
		else:
			post = 	Post(tags = tags , title = title , body= body , author = request.user , tagname = thetag.tagname)
			post.save()
			return redirect('personalspace')
	else:
		return redirect('personalspace')			