from django.db import models
from django.contrib.auth.models import User
from django.utils import timezone
import datetime
# Create your models here.
class Tags(models.Model):
	tagname = models.CharField(max_length=255)

	def __str__(self):
		return str(self.pk)+"  "+str(self.tagname)

class Post(models.Model):
	tags = models.IntegerField()
	title = models.CharField(max_length=255)
	author = models.ForeignKey(User , on_delete=models.CASCADE)
	body  = models.TextField()
	tagname = models.CharField(max_length=255 , default=0)

	def __str__(self):
		return "Primarykey="+str(self.pk)+"  Tags="+str(self.tags)+"  "+str(self.title) + ' | ' + str(self.author)

class alpha(models.Model):
	userid = models.ForeignKey(User,on_delete=models.CASCADE)
	ML = models.IntegerField(default=0)
	RL = models.IntegerField(default=0)
	DIP = models.IntegerField(default=0)
	MATHS = models.IntegerField(default=0)

	python = models.IntegerField(default=0)
	physics = models.IntegerField(default=0)
	chemistry = models.IntegerField(default=0)
	computer_science = models.IntegerField(default=0)

	arts = models.IntegerField(default=0)
	geography = models.IntegerField(default=0)
	architecture = models.IntegerField(default=0)
	engineering = models.IntegerField(default=0)
	literature = models.IntegerField(default=0)


	def __str__(self):
		return str(self.userid)


class total(models.Model):
	userid = models.ForeignKey(User,on_delete=models.CASCADE)
	ML = models.IntegerField(default=0)
	RL = models.IntegerField(default=0)
	DIP = models.IntegerField(default=0)
	MATHS = models.IntegerField(default=0)

	python = models.IntegerField(default=0)
	physics = models.IntegerField(default=0)
	chemistry = models.IntegerField(default=0)
	computer_science = models.IntegerField(default=0)

	arts = models.IntegerField(default=0)
	geography = models.IntegerField(default=0)
	architecture = models.IntegerField(default=0)
	engineering = models.IntegerField(default=0)
	literature = models.IntegerField(default=0)
	
	def __str__(self):
		return str(self.userid)