'use strict';
const express = require('express')
const bodyParser = require('body-parser')
let request = require('request')
const process = require('process')

const app = express()
let port = 5000, resource_id, functionHash, runtime, idleTime = 30

resource_id = process.argv[2]
functionHash = process.argv[3]
port = process.argv[4]
runtime = process.argv[5]
request = request.defaults({
    headers: { 'x-resource-id': resource_id }
});

let kafka = require('kafka-node'),
    Producer = kafka.Producer,
    client = new kafka.KafkaClient({
        kafkaHost: '10.129.6.5:9092',
        autoConnect: true
    }),
    producer = new Producer(client)

app.use(bodyParser.urlencoded({ extended: true }))
app.use(bodyParser.json())

let lastRequest = Date.now(), totalRequest = 0
app.post('/serverless/function/execute/', (req, res) => {
    let payload = req.body
    lastRequest = Date.now()
    totalRequest++
    executor(payload).then((result) => {
        res.json(result)
    })
})

app.post('/serverless/worker/timeout', (req, res) => {
    idleTime = req.body.timeout
    console.log("Idle time set to: ", idleTime);
    
})

function executor(payload) {
    return new Promise((resolve, reject) => {
        
    })
}

app.listen(port, () => {
    console.log(`Resource ${resource_id} Server listening on port ${port}!`)
    producer.send(
    [{
        topic: "deployed",
        messages: JSON.stringify({ functionHash, portExternal: port, 
            runtime, resource_id, entity_id: process.pid}),
        "status": true
    }], () => { })
})

function shouldDie() {
    
    if (Date.now() - lastRequest > idleTime * 1000) {
        let message = JSON.stringify({
            functionHash, portExternal: port,
            runtime, resource_id, entity_id: process.pid,
            total_request: totalRequest
        })

        console.log("Idle for too long. Exiting");
        producer.send(
            [
                {topic: "removeWorker", messages: message }
            ], () => {
                console.log("Ending worker for function", functionHash, "resource_id", resource_id);
                process.exit(0)
            })
        
    }
}

setInterval(shouldDie, 1000);