const constants = require('.././constants.json');

let log_channel = constants.log_channel,
    metrics = { longterm: {}, shortterm: {} }

let kafka = require('kafka-node'),
    Producer = kafka.Producer,
    client = new kafka.KafkaClient({
        kafkaHost: constants.kafka_host,
        autoConnect: true
    }),
    producer = new Producer(client)

function collectMetrics(metric) {
    
    if (!(metric.functionHash in metrics.shortterm)) {
        
        metrics.shortterm[metric.functionHash] = {
            coldstart: 0,
            coldstart_total_request: 0,
            warm_total_request: 0,
            warmstart: 0,
            worker_count: 0
        }
    }
    if (metric.type === 'coldstart') {
        metrics.shortterm[metric.functionHash].coldstart += metric.value
        metrics.shortterm[metric.functionHash].coldstart_total_request += 1
    } else if (metric.type === 'warmstart') {
        metrics.shortterm[metric.functionHash].warmstart += metric.value
        metrics.shortterm[metric.functionHash].warm_total_request += 1
    } else if (metric.type === 'scale') {
        metrics.shortterm[metric.functionHash].worker_count = metric.value
    }
    // console.log(metrics);
    
}
/**
 * FIXME: Some error causing longterm metrics to be flushed.
 */
function broadcastMetrics() {
    
    if (Object.keys(metrics.shortterm).length !== 0) {
        for (let [functionHash, metric] of Object.entries(metrics.shortterm)) {

            if (metrics.longterm[functionHash] === undefined) {
                
                metrics.longterm[functionHash] = {
                    coldstart: 0,
                    coldstart_total_request: 0,
                    warm_total_request: 0,
                    warmstart: 0,
                }
            }
            
            metrics.longterm[functionHash].coldstart = metrics.longterm[functionHash].coldstart 
                            * metrics.longterm[functionHash].coldstart_total_request
                            + metric.coldstart
            
            metrics.longterm[functionHash].coldstart_total_request += metric.coldstart_total_request
            metrics.longterm[functionHash].coldstart /= (metrics.longterm[functionHash].coldstart_total_request != 0)? 
                        metrics.longterm[functionHash].coldstart_total_request: 1

            metrics.longterm[functionHash].warmstart = metrics.longterm[functionHash].warmstart
                            * metrics.longterm[functionHash].warm_total_request
                            + metric.warmstart
            metrics.longterm[functionHash].warm_total_request += metric.warm_total_request
            metrics.longterm[functionHash].warmstart /= (metrics.longterm[functionHash].warm_total_request != 0)? 
                        metrics.longterm[functionHash].warm_total_request: 1

            metric.coldstart /= (metric.coldstart_total_request != 0)? metric.coldstart_total_request: 1
            metric.warmstart /= (metric.warm_total_request != 0)? metric.warm_total_request: 1
        }
        metrics.timestamp = Date.now()
        console.log(metrics);
        
        let log = [{
            topic: log_channel,
            messages: JSON.stringify({
                metrics
            }),
            partition: 0
        }]
        producer.send(log, () => { })
        metrics.shortterm = {}
    }
}

module.exports = {
    collectMetrics, broadcastMetrics
}