#include <core.p4>
#define V1MODEL_VERSION 20200408
#include <v1model.p4>
#include "includes/defines.p4"
#include "includes/headers_test.p4"
#include "includes/parsers.p4"


control ingress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    
    @name(".set_egress") action set_egress(bit<16> egress_spec)     {
        hdr.udp.checksum = 16w0;
        standard_metadata.egress_spec = egress_spec;
        hdr.ipv4.ttl = hdr.ipv4.ttl - 8w1;
    }
    @name(".ipv4_route") table fwd {
        actions = {
            set_egress;
        }
        key = {
            standard_metadata.ingress_port : exact;
        }
        size = 8192;
    }

    apply {
        if (hdr.ipv4.isValid()) {
            if (hdr.udp.dstPort == MDS_PORT) {
                if (standard_metadata.instance_type == PKT_INSTANCE_TYPE_NORMAL) {
                    meta.resubmit_meta.data = hdr.map_hdr.data;
                    meta.resubmit_meta.current_state = 8w0;
                    fwd.apply(); 
                } 
            } else if (hdr.udp.dstPort == REPLY_PORT) {
                bit<8> chain_state;
                bit<32> index = (bit<32>) hdr.map_hdr.exec_id;
                @atomic {
                    current_state.read(chain_state, index);
                    chain_state = chain_state | (8w1 << hdr.map_hdr.function_id);
                    current_state.write(index, chain_state);
                }
                hdr.map_hdr.data = (bit<32>)chain_state;
                // fwd.apply();
                standard_metadata.egress_spec = standard_metadata.ingress_port;
                
            } else {
                fwd.apply();
            }
        } else {
            fwd.apply();
        }
    }
}

control egress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    @name(".ethernet_set_mac_act") action ethernet_set_mac_act(bit<48> smac, bit<48> dmac) {
        hdr.ethernet.srcAddr = smac;
        hdr.ethernet.dstAddr = dmac;
    }
    @name(".ethernet_set_mac") table ethernet_set_mac {
        actions = {
            ethernet_set_mac_act;
        }
        key = {
            standard_metadata.egress_port: exact;
        }
    }


    @name(".clone_packet") action clone_packet() {
        clone3(CloneType.E2E, 4, {standard_metadata, meta});
    }

    @name(".clone_packet") action clone_packet2() {
        clone3(CloneType.E2E, 3, {standard_metadata, meta});
    }

    @name(".clone_packet") action clone_packet3() {
        clone3(CloneType.E2E, 2, {standard_metadata, meta});
    }

    @name(".recirculate_packet") action recirculate_packet() {
        recirculate({standard_metadata, meta});
    }

    @name(".update_packet") action update_packet() {
        hdr.udp.dstPort = MDS_PORT;
        hdr.udp.srcPort = REPLY_PORT;
        hdr.ipv4.dstAddr = SERVER_IP;
        // hdr.ipv4.srcAddr = SERVER_IP;
        standard_metadata.egress_spec = standard_metadata.ingress_port;
    }

    @name(".reroute_packet_act") action reroute_packet_act(bit<32> dstAddr) {
        hdr.ipv4.dstAddr = dstAddr;
    }

    @name("reroute_packet")table reroute_packet {
        actions = {
            reroute_packet_act;
        }
        key = {
            standard_metadata.egress_port: exact;
        }
    }

    apply {
        if (hdr.udp.dstPort == MDS_PORT) {
            if (standard_metadata.instance_type == PKT_INSTANCE_TYPE_NORMAL || standard_metadata.instance_type == PKT_INSTANCE_TYPE_INGRESS_RECIRC) {
                meta.exec_hdr.function_count = hdr.map_hdr.function_count;
                hdr.map_hdr.function_id = hdr.map_hdr.function_count;
                // hdr.map_hdr.data = (bit<32>)standard_metadata.egress_port; 
            } else if (standard_metadata.instance_type == PKT_INSTANCE_TYPE_EGRESS_CLONE) {
                meta.exec_hdr.function_count = meta.exec_hdr.function_count - 8w1;
                hdr.map_hdr.function_id = meta.exec_hdr.function_count;
            }
            /**
            * create a packet replica for next function to be checked
            **/
            if (meta.exec_hdr.function_count > 0) {
                if (meta.exec_hdr.function_count == 5)
                    clone_packet();
                if (meta.exec_hdr.function_count == 4)
                    clone_packet3();
                if (meta.exec_hdr.function_count == 3)
                    clone_packet2();
                
                hdr.map_hdr.data = 32w1;
            } else {
                hdr.map_hdr.data = 32w2;
            }
            // bit<8> dependency = 8w0;
            // bit<8> chain_state;
            // bit<8> function_state = 8w0;
            // @atomic {
            //     current_state.read(chain_state, hdr.map_hdr.exec_id);
            // }
            // if (meta.exec_hdr.function_count == 8w0) {
            //     dependency = hdr.map_hdr.f0;
            //     function_state = 8w1 << 0;
            // } else if (meta.exec_hdr.function_count == 8w1) {
            //     dependency = hdr.map_hdr.f1;
            //     function_state = 8w1 << 1;
            // } else if (meta.exec_hdr.function_count == 8w2) {
            //     dependency = hdr.map_hdr.f2;
            //     function_state = 8w1 << 2;
            // } else if (meta.exec_hdr.function_count == 8w3) {
            //     dependency = hdr.map_hdr.f3;
            //     function_state = 8w1 << 3;
            // } else if (meta.exec_hdr.function_count == 8w4) {
            //     dependency = hdr.map_hdr.f4;
            //     function_state = 8w1 << 4;
            // }
            
            // hdr.map_hdr.data = (bit<32>)(meta.exec_hdr.function_count);
            // /**
            // * if current function under scanner has not executed
            // * and its dependency condition is met continue
            // **/
            // // hdr.map_hdr.data = (bit<32>)123;
            // bit<8> function_dispatch_state;
            // @atomic {
            //     dispatch_state.read(function_dispatch_state, hdr.map_hdr.exec_id);
            
            //     // hdr.map_hdr.data = (bit<32>) function_dispatch_state;
            //     if (((function_dispatch_state & function_state) == 8w0) && ((chain_state & dependency) == dependency)) {
            //         function_dispatch_state = function_dispatch_state | (function_state);
            //         dispatch_state.write(hdr.map_hdr.exec_id, function_dispatch_state);
            //         // reroute_packet.apply();
            //         hdr.udp.dstPort = MDS_PORT;
            //     } else {
            //         hdr.udp.dstPort = 5000;
            //     }
            // }
        } else if (hdr.udp.dstPort == REPLY_PORT) {
            update_packet();
            recirculate_packet();
        }
        // ethernet_set_mac.apply();
    }
}

control DeparserImpl(packet_out packet, in headers hdr) {
    apply {
        packet.emit<ethernet_t>(hdr.ethernet);
        packet.emit<ipv4_t>(hdr.ipv4);
        packet.emit<udp_t>(hdr.udp);
        packet.emit<map_hdr_t>(hdr.map_hdr);
    }
}

control verifyChecksum(inout headers hdr, inout metadata meta) {
    apply {
        verify_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

control computeChecksum(inout headers hdr, inout metadata meta) {
    apply {
        update_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

V1Switch<headers, metadata>(ParserImpl(), verifyChecksum(), ingress(), egress(), computeChecksum(), DeparserImpl()) main;
