#include <core.p4>
#define V1MODEL_VERSION 20200408
#include <v1model.p4>
#include "includes/defines.p4"
#include "includes/headers.p4"
#include "includes/parsers.p4"

control egress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {
    @name(".ethernet_set_mac_act") action ethernet_set_mac_act(bit<48> smac, bit<48> dmac) {
        hdr.ethernet.srcAddr = smac;
        hdr.ethernet.dstAddr = dmac;
    }
    @name(".ethernet_set_mac") table ethernet_set_mac {
        actions = {
            ethernet_set_mac_act;
        }
        key = {
            standard_metadata.egress_port: exact;
        }
    }
    apply {
        ethernet_set_mac.apply();
    }
}

control ingress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {
    @name("._resubmit_act") action _resubmit_act() {
        resubmit({ standard_metadata, meta.resubmit_meta });
    }
    @name("._resubmit") table _resubmit {
        actions = {
            _resubmit_act;
        }
    }
    
    @name(".copy_meta_act") action copy_meta_act() {
        hdr.map_hdr.data = meta.resubmit_meta.data;
    }
    @name(".copy_meta") table copy_meta {
        actions = {
            copy_meta_act;
        }
    }


    @name(".function1_act") action function1_act() {
        meta.resubmit_meta.data = meta.resubmit_meta.data + 32w1;
        hdr.map_hdr.data = meta.resubmit_meta.data;
    }
    @name(".function1") table function1 {
        actions = {
            function1_act;
        }
    }

    @name(".function2_act") action function2_act() {
        meta.resubmit_meta.data = meta.resubmit_meta.data + 32w2;
        hdr.map_hdr.data = meta.resubmit_meta.data;
    }
    @name(".function2") table function2 {
        actions = {
            function2_act;
        }
    }
    
    @name(".set_egress") action set_egress(bit<9> egress_spec) {
        hdr.udp.checksum = 16w0; // TODO: check later how to calculate checksum for payload.
        standard_metadata.egress_spec = egress_spec;
        hdr.ipv4.ttl = hdr.ipv4.ttl - 8w1;
    }


    // @stage(11) 
    @name(".ipv4_route") table ipv4_route {
        actions = {
            set_egress;
        }
        key = {
            hdr.ipv4.dstAddr: exact;
        }
        size = 8192;
    }


    apply {
        // bit<8> tmp = meta.resubmit_meta.current_state;
        // if ((tmp & 8w1 == 0) && (tmp & hdr.map_hdr.f1) == hdr.map_hdr.f1) {
        //     function1.apply();
        //     meta.resubmit_meta.current_state = meta.resubmit_meta.current_state | 8w1;
        //     _resubmit.apply();
        // // } else if (tmp & 8w2 == 0 && (tmp & hdr.map_hdr.f2) == hdr.map_hdr.f2) {
        // //     function2.apply();
        // //     meta.resubmit_meta.current_state = meta.resubmit_meta.current_state | 8w2;
        // //     _resubmit.apply();
        // } else {
        //     copy_meta.apply();
        //     ipv4_route.apply();
        // }
        // copy_meta.apply();
        ipv4_route.apply();
    }
}

control DeparserImpl(packet_out packet, in headers hdr) {
    apply {
        packet.emit(hdr.ethernet);
        packet.emit(hdr.ipv4);
        packet.emit(hdr.udp);
        packet.emit(hdr.map_hdr);
        packet.emit(hdr.tcp);
    }
}

control verifyChecksum(inout headers hdr, inout metadata meta) {
    apply {
    }
}

control computeChecksum(inout headers hdr, inout metadata meta) {
    apply {
        update_checksum(true, { 
            hdr.ipv4.version, 
            hdr.ipv4.ihl, 
            hdr.ipv4.diffserv, 
            hdr.ipv4.totalLen, 
            hdr.ipv4.identification, 
            hdr.ipv4.flags, 
            hdr.ipv4.fragOffset, 
            hdr.ipv4.ttl, 
            hdr.ipv4.protocol, 
            hdr.ipv4.srcAddr, 
            hdr.ipv4.dstAddr }, 
            hdr.ipv4.hdrChecksum, 
            HashAlgorithm.csum16
        );
    }
}

V1Switch(ParserImpl(), verifyChecksum(), ingress(), egress(), computeChecksum(), DeparserImpl()) main;

