#include <core.p4>
#define V1MODEL_VERSION 20200408
#include <v1model.p4>
#include "includes/defines.p4"
#include "includes/headers_mininet.p4"
#include "includes/parsers.p4"

control ingress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {
    
    // @name(".set_egress") action set_egress() {
        
    //     bit<32> temp = hdr.ipv4.dstAddr;
    //     hdr.ipv4.dstAddr = hdr.ipv4.srcAddr;
    //     hdr.ipv4.srcAddr = temp;
    //     hdr.udp.dstPort = 9000;
    //     bit<48> tempEth = hdr.ethernet.dstAddr;
    //     hdr.ethernet.dstAddr = hdr.ethernet.srcAddr;
    //     hdr.ethernet.srcAddr = tempEth;
    //     standard_metadata.egress_spec = standard_metadata.ingress_port;
    //     hdr.ipv4.ttl = hdr.ipv4.ttl - 8w1;
    // }

    action set_ecmp_select(bit<16> ecmp_base, bit<32> ecmp_count) {
        hash(hdr.map_hdr.chain_id,
	    HashAlgorithm.crc32,
	    ecmp_base,
	    { hdr.map_hdr.data },
	    ecmp_count);
    }

    @name(".fwd_act") action fwd_act(bit<16> port) {
        standard_metadata.egress_spec = port;
    }

    @name(".fwd") table fwd {
        actions = {
            fwd_act;
        }
        key = {
            standard_metadata.ingress_port : exact;
        }
    }

    apply {
        if (hdr.ipv4.isValid() && hdr.udp.dstPort == REPLY_PORT) {
            set_ecmp_select(0, 4);
        }
        fwd.apply();
    }
}

control egress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    // @name(".ethernet_set_mac_act") action ethernet_set_mac_act(bit<48> smac, bit<48> dmac) {
    //     hdr.ethernet.srcAddr = smac;
    //     hdr.ethernet.dstAddr = dmac;
    // }
    // @name(".ethernet_set_mac") table ethernet_set_mac {
    //     actions = {
    //         ethernet_set_mac_act;
    //     }
    //     key = {
    //         standard_metadata.egress_port: exact;
    //     }
    // }

    @name("fix_checksum") action fix_checksum() {
        hdr.udp.checksum = 16w0;
    }
  

    apply {
        // if (hdr.udp.dstPort == MDS_PORT) {           
        //     ethernet_set_mac.apply();
        // }
        fix_checksum();
    }
}

control DeparserImpl(packet_out packet, in headers hdr) {
    apply {
        packet.emit<ethernet_t>(hdr.ethernet);
        packet.emit<ipv4_t>(hdr.ipv4);
        packet.emit<udp_t>(hdr.udp);
        packet.emit<map_hdr_t>(hdr.map_hdr);
    }
}

control verifyChecksum(inout headers hdr, inout metadata meta) {
    apply {
        verify_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

control computeChecksum(inout headers hdr, inout metadata meta) {
    apply {
        update_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

V1Switch<headers, metadata>(ParserImpl(), verifyChecksum(), ingress(), egress(), computeChecksum(), DeparserImpl()) main;
