/* Copyright (C) 2015-2016,  Netronome Systems, Inc.  All rights reserved. */

#ifndef __PIF_HEADERS_H__
#define __PIF_HEADERS_H__

/* Generated C source defining PIF headers, metadata and registers */
/* Warning: your edits to this file may be lost */

/*
 * Packet headers
 */

/* ethernet (14B) */
struct pif_header_ethernet {
    /* dstAddr [32;16] */
    unsigned int dstAddr:32;
    /* dstAddr [16;0] */
    unsigned int __dstAddr_1:16;
    /* srcAddr [16;32] */
    unsigned int srcAddr:16;
    /* srcAddr [32;0] */
    unsigned int __srcAddr_1:32;
    unsigned int etherType:16;
};

/* ethernet field accessor macros */
#define PIF_HEADER_GET_ethernet___dstAddr___0(_hdr_p) ((((_hdr_p)->dstAddr & 0xffff) << 16) | ((_hdr_p)->__dstAddr_1)) /* ethernet.dstAddr [32;0] */

#define PIF_HEADER_SET_ethernet___dstAddr___0(_hdr_p, _val) \
    do { \
        (_hdr_p)->dstAddr &= (unsigned)(0xffff0000); \
        (_hdr_p)->dstAddr |= (unsigned)((((_val) >> 16) & 0xffff)); \
        (_hdr_p)->__dstAddr_1 = (unsigned)(((_val))); \
    } while (0) /* ethernet.dstAddr[32;0] */

#define PIF_HEADER_GET_ethernet___dstAddr___1(_hdr_p) ((((_hdr_p)->dstAddr >> 16) & 0xffff)) /* ethernet.dstAddr [16;32] */

#define PIF_HEADER_SET_ethernet___dstAddr___1(_hdr_p, _val) \
    do { \
        (_hdr_p)->dstAddr &= (unsigned)(0xffff); \
        (_hdr_p)->dstAddr |= (unsigned)((((_val) & 0xffff) << 16)); \
    } while (0) /* ethernet.dstAddr[16;32] */

#define PIF_HEADER_GET_ethernet___srcAddr___0(_hdr_p) (((_hdr_p)->__srcAddr_1)) /* ethernet.srcAddr [32;0] */

#define PIF_HEADER_SET_ethernet___srcAddr___0(_hdr_p, _val) \
    do { \
        (_hdr_p)->__srcAddr_1 = (unsigned)(((_val))); \
    } while (0) /* ethernet.srcAddr[32;0] */

#define PIF_HEADER_GET_ethernet___srcAddr___1(_hdr_p) (((_hdr_p)->srcAddr)) /* ethernet.srcAddr [16;32] */

#define PIF_HEADER_SET_ethernet___srcAddr___1(_hdr_p, _val) \
    do { \
        (_hdr_p)->srcAddr = (unsigned)(((_val))); \
    } while (0) /* ethernet.srcAddr[16;32] */

#define PIF_HEADER_GET_ethernet___etherType(_hdr_p) (((_hdr_p)->etherType)) /* ethernet.etherType [16;0] */

#define PIF_HEADER_SET_ethernet___etherType(_hdr_p, _val) \
    do { \
        (_hdr_p)->etherType = (unsigned)(((_val))); \
    } while (0) /* ethernet.etherType[16;0] */


/* map_hdr (25B) */
struct pif_header_map_hdr {
    unsigned int chain_id:32;
    unsigned int exec_id:32;
    unsigned int function_id:32;
    unsigned int data:32;
    unsigned int function_count:32;
    unsigned int f0:8;
    unsigned int f1:8;
    unsigned int f2:8;
    unsigned int f3:8;
    unsigned int f4:8;
};

/* map_hdr field accessor macros */
#define PIF_HEADER_GET_map_hdr___chain_id(_hdr_p) (((_hdr_p)->chain_id)) /* map_hdr.chain_id [32;0] */

#define PIF_HEADER_SET_map_hdr___chain_id(_hdr_p, _val) \
    do { \
        (_hdr_p)->chain_id = (unsigned)(((_val))); \
    } while (0) /* map_hdr.chain_id[32;0] */

#define PIF_HEADER_GET_map_hdr___exec_id(_hdr_p) (((_hdr_p)->exec_id)) /* map_hdr.exec_id [32;0] */

#define PIF_HEADER_SET_map_hdr___exec_id(_hdr_p, _val) \
    do { \
        (_hdr_p)->exec_id = (unsigned)(((_val))); \
    } while (0) /* map_hdr.exec_id[32;0] */

#define PIF_HEADER_GET_map_hdr___function_id(_hdr_p) (((_hdr_p)->function_id)) /* map_hdr.function_id [32;0] */

#define PIF_HEADER_SET_map_hdr___function_id(_hdr_p, _val) \
    do { \
        (_hdr_p)->function_id = (unsigned)(((_val))); \
    } while (0) /* map_hdr.function_id[32;0] */

#define PIF_HEADER_GET_map_hdr___data(_hdr_p) (((_hdr_p)->data)) /* map_hdr.data [32;0] */

#define PIF_HEADER_SET_map_hdr___data(_hdr_p, _val) \
    do { \
        (_hdr_p)->data = (unsigned)(((_val))); \
    } while (0) /* map_hdr.data[32;0] */

#define PIF_HEADER_GET_map_hdr___function_count(_hdr_p) (((_hdr_p)->function_count)) /* map_hdr.function_count [32;0] */

#define PIF_HEADER_SET_map_hdr___function_count(_hdr_p, _val) \
    do { \
        (_hdr_p)->function_count = (unsigned)(((_val))); \
    } while (0) /* map_hdr.function_count[32;0] */

#define PIF_HEADER_GET_map_hdr___f0(_hdr_p) (((_hdr_p)->f0)) /* map_hdr.f0 [8;0] */

#define PIF_HEADER_SET_map_hdr___f0(_hdr_p, _val) \
    do { \
        (_hdr_p)->f0 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f0[8;0] */

#define PIF_HEADER_GET_map_hdr___f1(_hdr_p) (((_hdr_p)->f1)) /* map_hdr.f1 [8;0] */

#define PIF_HEADER_SET_map_hdr___f1(_hdr_p, _val) \
    do { \
        (_hdr_p)->f1 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f1[8;0] */

#define PIF_HEADER_GET_map_hdr___f2(_hdr_p) (((_hdr_p)->f2)) /* map_hdr.f2 [8;0] */

#define PIF_HEADER_SET_map_hdr___f2(_hdr_p, _val) \
    do { \
        (_hdr_p)->f2 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f2[8;0] */

#define PIF_HEADER_GET_map_hdr___f3(_hdr_p) (((_hdr_p)->f3)) /* map_hdr.f3 [8;0] */

#define PIF_HEADER_SET_map_hdr___f3(_hdr_p, _val) \
    do { \
        (_hdr_p)->f3 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f3[8;0] */

#define PIF_HEADER_GET_map_hdr___f4(_hdr_p) (((_hdr_p)->f4)) /* map_hdr.f4 [8;0] */

#define PIF_HEADER_SET_map_hdr___f4(_hdr_p, _val) \
    do { \
        (_hdr_p)->f4 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f4[8;0] */


/* udp (8B) */
struct pif_header_udp {
    unsigned int srcPort:16;
    unsigned int dstPort:16;
    unsigned int length_:16;
    unsigned int checksum:16;
};

/* udp field accessor macros */
#define PIF_HEADER_GET_udp___srcPort(_hdr_p) (((_hdr_p)->srcPort)) /* udp.srcPort [16;0] */

#define PIF_HEADER_SET_udp___srcPort(_hdr_p, _val) \
    do { \
        (_hdr_p)->srcPort = (unsigned)(((_val))); \
    } while (0) /* udp.srcPort[16;0] */

#define PIF_HEADER_GET_udp___dstPort(_hdr_p) (((_hdr_p)->dstPort)) /* udp.dstPort [16;0] */

#define PIF_HEADER_SET_udp___dstPort(_hdr_p, _val) \
    do { \
        (_hdr_p)->dstPort = (unsigned)(((_val))); \
    } while (0) /* udp.dstPort[16;0] */

#define PIF_HEADER_GET_udp___length_(_hdr_p) (((_hdr_p)->length_)) /* udp.length_ [16;0] */

#define PIF_HEADER_SET_udp___length_(_hdr_p, _val) \
    do { \
        (_hdr_p)->length_ = (unsigned)(((_val))); \
    } while (0) /* udp.length_[16;0] */

#define PIF_HEADER_GET_udp___checksum(_hdr_p) (((_hdr_p)->checksum)) /* udp.checksum [16;0] */

#define PIF_HEADER_SET_udp___checksum(_hdr_p, _val) \
    do { \
        (_hdr_p)->checksum = (unsigned)(((_val))); \
    } while (0) /* udp.checksum[16;0] */


/* ipv4 (20B) */
struct pif_header_ipv4 {
    unsigned int version:4;
    unsigned int ihl:4;
    unsigned int diffserv:8;
    unsigned int totalLen:16;
    unsigned int identification:16;
    unsigned int flags:3;
    unsigned int fragOffset:13;
    unsigned int ttl:8;
    unsigned int protocol:8;
    unsigned int hdrChecksum:16;
    unsigned int srcAddr:32;
    unsigned int dstAddr:32;
};

/* ipv4 field accessor macros */
#define PIF_HEADER_GET_ipv4___version(_hdr_p) (((_hdr_p)->version)) /* ipv4.version [4;0] */

#define PIF_HEADER_SET_ipv4___version(_hdr_p, _val) \
    do { \
        (_hdr_p)->version = (unsigned)(((_val))); \
    } while (0) /* ipv4.version[4;0] */

#define PIF_HEADER_GET_ipv4___ihl(_hdr_p) (((_hdr_p)->ihl)) /* ipv4.ihl [4;0] */

#define PIF_HEADER_SET_ipv4___ihl(_hdr_p, _val) \
    do { \
        (_hdr_p)->ihl = (unsigned)(((_val))); \
    } while (0) /* ipv4.ihl[4;0] */

#define PIF_HEADER_GET_ipv4___diffserv(_hdr_p) (((_hdr_p)->diffserv)) /* ipv4.diffserv [8;0] */

#define PIF_HEADER_SET_ipv4___diffserv(_hdr_p, _val) \
    do { \
        (_hdr_p)->diffserv = (unsigned)(((_val))); \
    } while (0) /* ipv4.diffserv[8;0] */

#define PIF_HEADER_GET_ipv4___totalLen(_hdr_p) (((_hdr_p)->totalLen)) /* ipv4.totalLen [16;0] */

#define PIF_HEADER_SET_ipv4___totalLen(_hdr_p, _val) \
    do { \
        (_hdr_p)->totalLen = (unsigned)(((_val))); \
    } while (0) /* ipv4.totalLen[16;0] */

#define PIF_HEADER_GET_ipv4___identification(_hdr_p) (((_hdr_p)->identification)) /* ipv4.identification [16;0] */

#define PIF_HEADER_SET_ipv4___identification(_hdr_p, _val) \
    do { \
        (_hdr_p)->identification = (unsigned)(((_val))); \
    } while (0) /* ipv4.identification[16;0] */

#define PIF_HEADER_GET_ipv4___flags(_hdr_p) (((_hdr_p)->flags)) /* ipv4.flags [3;0] */

#define PIF_HEADER_SET_ipv4___flags(_hdr_p, _val) \
    do { \
        (_hdr_p)->flags = (unsigned)(((_val))); \
    } while (0) /* ipv4.flags[3;0] */

#define PIF_HEADER_GET_ipv4___fragOffset(_hdr_p) (((_hdr_p)->fragOffset)) /* ipv4.fragOffset [13;0] */

#define PIF_HEADER_SET_ipv4___fragOffset(_hdr_p, _val) \
    do { \
        (_hdr_p)->fragOffset = (unsigned)(((_val))); \
    } while (0) /* ipv4.fragOffset[13;0] */

#define PIF_HEADER_GET_ipv4___ttl(_hdr_p) (((_hdr_p)->ttl)) /* ipv4.ttl [8;0] */

#define PIF_HEADER_SET_ipv4___ttl(_hdr_p, _val) \
    do { \
        (_hdr_p)->ttl = (unsigned)(((_val))); \
    } while (0) /* ipv4.ttl[8;0] */

#define PIF_HEADER_GET_ipv4___protocol(_hdr_p) (((_hdr_p)->protocol)) /* ipv4.protocol [8;0] */

#define PIF_HEADER_SET_ipv4___protocol(_hdr_p, _val) \
    do { \
        (_hdr_p)->protocol = (unsigned)(((_val))); \
    } while (0) /* ipv4.protocol[8;0] */

#define PIF_HEADER_GET_ipv4___hdrChecksum(_hdr_p) (((_hdr_p)->hdrChecksum)) /* ipv4.hdrChecksum [16;0] */

#define PIF_HEADER_SET_ipv4___hdrChecksum(_hdr_p, _val) \
    do { \
        (_hdr_p)->hdrChecksum = (unsigned)(((_val))); \
    } while (0) /* ipv4.hdrChecksum[16;0] */

#define PIF_HEADER_GET_ipv4___srcAddr(_hdr_p) (((_hdr_p)->srcAddr)) /* ipv4.srcAddr [32;0] */

#define PIF_HEADER_SET_ipv4___srcAddr(_hdr_p, _val) \
    do { \
        (_hdr_p)->srcAddr = (unsigned)(((_val))); \
    } while (0) /* ipv4.srcAddr[32;0] */

#define PIF_HEADER_GET_ipv4___dstAddr(_hdr_p) (((_hdr_p)->dstAddr)) /* ipv4.dstAddr [32;0] */

#define PIF_HEADER_SET_ipv4___dstAddr(_hdr_p, _val) \
    do { \
        (_hdr_p)->dstAddr = (unsigned)(((_val))); \
    } while (0) /* ipv4.dstAddr[32;0] */


/* tcp (20B) */
struct pif_header_tcp {
    unsigned int src_port:16;
    unsigned int dst_port:16;
    unsigned int seq_no:32;
    unsigned int ack_no:32;
    unsigned int data_offset:4;
    unsigned int res:3;
    unsigned int ecn:3;
    unsigned int ctrl:6;
    unsigned int window:16;
    unsigned int checksum:16;
    unsigned int urgent_ptr:16;
};

/* tcp field accessor macros */
#define PIF_HEADER_GET_tcp___src_port(_hdr_p) (((_hdr_p)->src_port)) /* tcp.src_port [16;0] */

#define PIF_HEADER_SET_tcp___src_port(_hdr_p, _val) \
    do { \
        (_hdr_p)->src_port = (unsigned)(((_val))); \
    } while (0) /* tcp.src_port[16;0] */

#define PIF_HEADER_GET_tcp___dst_port(_hdr_p) (((_hdr_p)->dst_port)) /* tcp.dst_port [16;0] */

#define PIF_HEADER_SET_tcp___dst_port(_hdr_p, _val) \
    do { \
        (_hdr_p)->dst_port = (unsigned)(((_val))); \
    } while (0) /* tcp.dst_port[16;0] */

#define PIF_HEADER_GET_tcp___seq_no(_hdr_p) (((_hdr_p)->seq_no)) /* tcp.seq_no [32;0] */

#define PIF_HEADER_SET_tcp___seq_no(_hdr_p, _val) \
    do { \
        (_hdr_p)->seq_no = (unsigned)(((_val))); \
    } while (0) /* tcp.seq_no[32;0] */

#define PIF_HEADER_GET_tcp___ack_no(_hdr_p) (((_hdr_p)->ack_no)) /* tcp.ack_no [32;0] */

#define PIF_HEADER_SET_tcp___ack_no(_hdr_p, _val) \
    do { \
        (_hdr_p)->ack_no = (unsigned)(((_val))); \
    } while (0) /* tcp.ack_no[32;0] */

#define PIF_HEADER_GET_tcp___data_offset(_hdr_p) (((_hdr_p)->data_offset)) /* tcp.data_offset [4;0] */

#define PIF_HEADER_SET_tcp___data_offset(_hdr_p, _val) \
    do { \
        (_hdr_p)->data_offset = (unsigned)(((_val))); \
    } while (0) /* tcp.data_offset[4;0] */

#define PIF_HEADER_GET_tcp___res(_hdr_p) (((_hdr_p)->res)) /* tcp.res [3;0] */

#define PIF_HEADER_SET_tcp___res(_hdr_p, _val) \
    do { \
        (_hdr_p)->res = (unsigned)(((_val))); \
    } while (0) /* tcp.res[3;0] */

#define PIF_HEADER_GET_tcp___ecn(_hdr_p) (((_hdr_p)->ecn)) /* tcp.ecn [3;0] */

#define PIF_HEADER_SET_tcp___ecn(_hdr_p, _val) \
    do { \
        (_hdr_p)->ecn = (unsigned)(((_val))); \
    } while (0) /* tcp.ecn[3;0] */

#define PIF_HEADER_GET_tcp___ctrl(_hdr_p) (((_hdr_p)->ctrl)) /* tcp.ctrl [6;0] */

#define PIF_HEADER_SET_tcp___ctrl(_hdr_p, _val) \
    do { \
        (_hdr_p)->ctrl = (unsigned)(((_val))); \
    } while (0) /* tcp.ctrl[6;0] */

#define PIF_HEADER_GET_tcp___window(_hdr_p) (((_hdr_p)->window)) /* tcp.window [16;0] */

#define PIF_HEADER_SET_tcp___window(_hdr_p, _val) \
    do { \
        (_hdr_p)->window = (unsigned)(((_val))); \
    } while (0) /* tcp.window[16;0] */

#define PIF_HEADER_GET_tcp___checksum(_hdr_p) (((_hdr_p)->checksum)) /* tcp.checksum [16;0] */

#define PIF_HEADER_SET_tcp___checksum(_hdr_p, _val) \
    do { \
        (_hdr_p)->checksum = (unsigned)(((_val))); \
    } while (0) /* tcp.checksum[16;0] */

#define PIF_HEADER_GET_tcp___urgent_ptr(_hdr_p) (((_hdr_p)->urgent_ptr)) /* tcp.urgent_ptr [16;0] */

#define PIF_HEADER_SET_tcp___urgent_ptr(_hdr_p, _val) \
    do { \
        (_hdr_p)->urgent_ptr = (unsigned)(((_val))); \
    } while (0) /* tcp.urgent_ptr[16;0] */


/*
 * Metadata
 */

/* standard_metadata (16B) */
struct pif_header_standard_metadata {
    unsigned int clone_spec:32;
    unsigned int egress_spec:16;
    unsigned int egress_port:16;
    unsigned int ingress_port:16;
    unsigned int packet_length:14;
    unsigned int checksum_error:1;
    unsigned int _padding_0:1;
    unsigned int egress_instance:10;
    unsigned int parser_error_location:8;
    unsigned int instance_type:4;
    unsigned int parser_status:3;
    unsigned int _padding_1:7;
};

/* standard_metadata field accessor macros */
#define PIF_HEADER_GET_standard_metadata___clone_spec(_hdr_p) (((_hdr_p)->clone_spec)) /* standard_metadata.clone_spec [32;0] */

#define PIF_HEADER_SET_standard_metadata___clone_spec(_hdr_p, _val) \
    do { \
        (_hdr_p)->clone_spec = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.clone_spec[32;0] */

#define PIF_HEADER_GET_standard_metadata___egress_spec(_hdr_p) (((_hdr_p)->egress_spec)) /* standard_metadata.egress_spec [16;0] */

#define PIF_HEADER_SET_standard_metadata___egress_spec(_hdr_p, _val) \
    do { \
        (_hdr_p)->egress_spec = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.egress_spec[16;0] */

#define PIF_HEADER_GET_standard_metadata___egress_port(_hdr_p) (((_hdr_p)->egress_port)) /* standard_metadata.egress_port [16;0] */

#define PIF_HEADER_SET_standard_metadata___egress_port(_hdr_p, _val) \
    do { \
        (_hdr_p)->egress_port = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.egress_port[16;0] */

#define PIF_HEADER_GET_standard_metadata___ingress_port(_hdr_p) (((_hdr_p)->ingress_port)) /* standard_metadata.ingress_port [16;0] */

#define PIF_HEADER_SET_standard_metadata___ingress_port(_hdr_p, _val) \
    do { \
        (_hdr_p)->ingress_port = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.ingress_port[16;0] */

#define PIF_HEADER_GET_standard_metadata___packet_length(_hdr_p) (((_hdr_p)->packet_length)) /* standard_metadata.packet_length [14;0] */

#define PIF_HEADER_SET_standard_metadata___packet_length(_hdr_p, _val) \
    do { \
        (_hdr_p)->packet_length = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.packet_length[14;0] */

#define PIF_HEADER_GET_standard_metadata___checksum_error(_hdr_p) (((_hdr_p)->checksum_error)) /* standard_metadata.checksum_error [1;0] */

#define PIF_HEADER_SET_standard_metadata___checksum_error(_hdr_p, _val) \
    do { \
        (_hdr_p)->checksum_error = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.checksum_error[1;0] */

#define PIF_HEADER_GET_standard_metadata____padding_0(_hdr_p) (((_hdr_p)->_padding_0)) /* standard_metadata._padding_0 [1;0] */

#define PIF_HEADER_SET_standard_metadata____padding_0(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_0 = (unsigned)(((_val))); \
    } while (0) /* standard_metadata._padding_0[1;0] */

#define PIF_HEADER_GET_standard_metadata___egress_instance(_hdr_p) (((_hdr_p)->egress_instance)) /* standard_metadata.egress_instance [10;0] */

#define PIF_HEADER_SET_standard_metadata___egress_instance(_hdr_p, _val) \
    do { \
        (_hdr_p)->egress_instance = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.egress_instance[10;0] */

#define PIF_HEADER_GET_standard_metadata___parser_error_location(_hdr_p) (((_hdr_p)->parser_error_location)) /* standard_metadata.parser_error_location [8;0] */

#define PIF_HEADER_SET_standard_metadata___parser_error_location(_hdr_p, _val) \
    do { \
        (_hdr_p)->parser_error_location = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.parser_error_location[8;0] */

#define PIF_HEADER_GET_standard_metadata___instance_type(_hdr_p) (((_hdr_p)->instance_type)) /* standard_metadata.instance_type [4;0] */

#define PIF_HEADER_SET_standard_metadata___instance_type(_hdr_p, _val) \
    do { \
        (_hdr_p)->instance_type = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.instance_type[4;0] */

#define PIF_HEADER_GET_standard_metadata___parser_status(_hdr_p) (((_hdr_p)->parser_status)) /* standard_metadata.parser_status [3;0] */

#define PIF_HEADER_SET_standard_metadata___parser_status(_hdr_p, _val) \
    do { \
        (_hdr_p)->parser_status = (unsigned)(((_val))); \
    } while (0) /* standard_metadata.parser_status[3;0] */

#define PIF_HEADER_GET_standard_metadata____padding_1(_hdr_p) (((_hdr_p)->_padding_1)) /* standard_metadata._padding_1 [7;0] */

#define PIF_HEADER_SET_standard_metadata____padding_1(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_1 = (unsigned)(((_val))); \
    } while (0) /* standard_metadata._padding_1[7;0] */


/* resubmit_meta (8B) */
struct pif_header_resubmit_meta {
    unsigned int data:32;
    unsigned int current_state:8;
    unsigned int _padding_0:24;
};

/* resubmit_meta field accessor macros */
#define PIF_HEADER_GET_resubmit_meta___data(_hdr_p) (((_hdr_p)->data)) /* resubmit_meta.data [32;0] */

#define PIF_HEADER_SET_resubmit_meta___data(_hdr_p, _val) \
    do { \
        (_hdr_p)->data = (unsigned)(((_val))); \
    } while (0) /* resubmit_meta.data[32;0] */

#define PIF_HEADER_GET_resubmit_meta___current_state(_hdr_p) (((_hdr_p)->current_state)) /* resubmit_meta.current_state [8;0] */

#define PIF_HEADER_SET_resubmit_meta___current_state(_hdr_p, _val) \
    do { \
        (_hdr_p)->current_state = (unsigned)(((_val))); \
    } while (0) /* resubmit_meta.current_state[8;0] */

#define PIF_HEADER_GET_resubmit_meta____padding_0(_hdr_p) (((_hdr_p)->_padding_0)) /* resubmit_meta._padding_0 [24;0] */

#define PIF_HEADER_SET_resubmit_meta____padding_0(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_0 = (unsigned)(((_val))); \
    } while (0) /* resubmit_meta._padding_0[24;0] */


/* ing_metadata (4B) */
struct pif_header_ing_metadata {
    unsigned int egress_port:9;
    unsigned int packet_type:4;
    unsigned int drop:1;
    unsigned int _padding_0:18;
};

/* ing_metadata field accessor macros */
#define PIF_HEADER_GET_ing_metadata___egress_port(_hdr_p) (((_hdr_p)->egress_port)) /* ing_metadata.egress_port [9;0] */

#define PIF_HEADER_SET_ing_metadata___egress_port(_hdr_p, _val) \
    do { \
        (_hdr_p)->egress_port = (unsigned)(((_val))); \
    } while (0) /* ing_metadata.egress_port[9;0] */

#define PIF_HEADER_GET_ing_metadata___packet_type(_hdr_p) (((_hdr_p)->packet_type)) /* ing_metadata.packet_type [4;0] */

#define PIF_HEADER_SET_ing_metadata___packet_type(_hdr_p, _val) \
    do { \
        (_hdr_p)->packet_type = (unsigned)(((_val))); \
    } while (0) /* ing_metadata.packet_type[4;0] */

#define PIF_HEADER_GET_ing_metadata___drop(_hdr_p) (((_hdr_p)->drop)) /* ing_metadata.drop [1;0] */

#define PIF_HEADER_SET_ing_metadata___drop(_hdr_p, _val) \
    do { \
        (_hdr_p)->drop = (unsigned)(((_val))); \
    } while (0) /* ing_metadata.drop[1;0] */

#define PIF_HEADER_GET_ing_metadata____padding_0(_hdr_p) (((_hdr_p)->_padding_0)) /* ing_metadata._padding_0 [18;0] */

#define PIF_HEADER_SET_ing_metadata____padding_0(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_0 = (unsigned)(((_val))); \
    } while (0) /* ing_metadata._padding_0[18;0] */


/* exec_hdr (4B) */
struct pif_header_exec_hdr {
    unsigned int function_count:8;
    unsigned int function:8;
    unsigned int _padding_0:16;
};

/* exec_hdr field accessor macros */
#define PIF_HEADER_GET_exec_hdr___function_count(_hdr_p) (((_hdr_p)->function_count)) /* exec_hdr.function_count [8;0] */

#define PIF_HEADER_SET_exec_hdr___function_count(_hdr_p, _val) \
    do { \
        (_hdr_p)->function_count = (unsigned)(((_val))); \
    } while (0) /* exec_hdr.function_count[8;0] */

#define PIF_HEADER_GET_exec_hdr___function(_hdr_p) (((_hdr_p)->function)) /* exec_hdr.function [8;0] */

#define PIF_HEADER_SET_exec_hdr___function(_hdr_p, _val) \
    do { \
        (_hdr_p)->function = (unsigned)(((_val))); \
    } while (0) /* exec_hdr.function[8;0] */

#define PIF_HEADER_GET_exec_hdr____padding_0(_hdr_p) (((_hdr_p)->_padding_0)) /* exec_hdr._padding_0 [16;0] */

#define PIF_HEADER_SET_exec_hdr____padding_0(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_0 = (unsigned)(((_val))); \
    } while (0) /* exec_hdr._padding_0[16;0] */



/*
 * Registers
 */

/* current_state (4B) */
struct pif_header_current_state {
    unsigned int _padding_0:24;
    unsigned int value:8;
};

/* current_state field accessor macros */
#define PIF_HEADER_GET_current_state___value(_hdr_p) (((_hdr_p)->value)) /* current_state.value [8;0] */

#define PIF_HEADER_SET_current_state___value(_hdr_p, _val) \
    do { \
        (_hdr_p)->value = (unsigned)(((_val))); \
    } while (0) /* current_state.value[8;0] */

#define PIF_HEADER_GET_current_state____padding_0(_hdr_p) (((_hdr_p)->_padding_0)) /* current_state._padding_0 [24;0] */

#define PIF_HEADER_SET_current_state____padding_0(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_0 = (unsigned)(((_val))); \
    } while (0) /* current_state._padding_0[24;0] */


/* batch (4B) */
struct pif_header_batch {
    unsigned int _padding_0:24;
    unsigned int value:8;
};

/* batch field accessor macros */
#define PIF_HEADER_GET_batch___value(_hdr_p) (((_hdr_p)->value)) /* batch.value [8;0] */

#define PIF_HEADER_SET_batch___value(_hdr_p, _val) \
    do { \
        (_hdr_p)->value = (unsigned)(((_val))); \
    } while (0) /* batch.value[8;0] */

#define PIF_HEADER_GET_batch____padding_0(_hdr_p) (((_hdr_p)->_padding_0)) /* batch._padding_0 [24;0] */

#define PIF_HEADER_SET_batch____padding_0(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_0 = (unsigned)(((_val))); \
    } while (0) /* batch._padding_0[24;0] */


/* dispatch_state (4B) */
struct pif_header_dispatch_state {
    unsigned int _padding_0:24;
    unsigned int value:8;
};

/* dispatch_state field accessor macros */
#define PIF_HEADER_GET_dispatch_state___value(_hdr_p) (((_hdr_p)->value)) /* dispatch_state.value [8;0] */

#define PIF_HEADER_SET_dispatch_state___value(_hdr_p, _val) \
    do { \
        (_hdr_p)->value = (unsigned)(((_val))); \
    } while (0) /* dispatch_state.value[8;0] */

#define PIF_HEADER_GET_dispatch_state____padding_0(_hdr_p) (((_hdr_p)->_padding_0)) /* dispatch_state._padding_0 [24;0] */

#define PIF_HEADER_SET_dispatch_state____padding_0(_hdr_p, _val) \
    do { \
        (_hdr_p)->_padding_0 = (unsigned)(((_val))); \
    } while (0) /* dispatch_state._padding_0[24;0] */


#endif /* __PIF_HEADERS_H__ */
