/* Copyright (C) 2015-2016,  Netronome Systems, Inc.  All rights reserved. */

#include <nfp/me.h>
#include "pif_common.h"

/****************************************
 * ingress_flow                         *
 ****************************************/

/* State transition functions */

static int handle_ingress_flow_ingress__tbl_act(__lmem uint32_t *_pif_parrep, __mem __addr40 uint32_t *actbuf, unsigned int actbuf_off, int *actlen, int *state)
{
    __gpr int action_id, ret;
    int next_state = PIF_CTLFLOW_STATE_ingress_flow_DONE;

#ifdef PIF_DEBUG
    __debug_label("pif_ctlflow_state_ingress_flow_ingress__tbl_act");
#endif

    {
        struct pif_action_actiondata_ingress__act actdata;
        __xwrite struct {
            union pif_action_opdata opdata;
            struct pif_action_actiondata_ingress__act actdata;
            } wr_buf;

        wr_buf.opdata.val32 = (PIF_ACTION_ID_ingress__act << PIF_ACTION_OPDATA_ACTION_ID_off) | ((sizeof(actdata) / 4) << PIF_ACTION_OPDATA_ACTDATA_CNT_off);
        actdata.__pif_table_no = 0xffffffff;
        actdata.__pif_rule_no = 0x0;
        wr_buf.actdata = actdata;

        mem_write32(&wr_buf,
                    actbuf + actbuf_off,
                    sizeof(wr_buf));
        *actlen = sizeof(wr_buf)/4;
    }

    next_state = PIF_CTLFLOW_STATE_ingress_flow_ingress__fwd; /* always */

    if (*actlen > 0) {
        __critical_path();
        ret = pif_action_execute(_pif_parrep, actbuf, actbuf_off, *actlen);
        if (ret < 0)
            return ret;
        __critical_path();
        if (ret > 0)
            next_state = PIF_CTLFLOW_STATE_ingress_flow_DONE;
        __critical_path();
    }

    *state = next_state;
    return 0;
}

static int handle_ingress_flow_ingress__fwd(__lmem uint32_t *_pif_parrep, __mem __addr40 uint32_t *actbuf, unsigned int actbuf_off, int *actlen, int *state)
{
    __gpr int action_id, ret;
    int next_state = PIF_CTLFLOW_STATE_ingress_flow_DONE;

#ifdef PIF_DEBUG
    __debug_label("pif_ctlflow_state_ingress_flow_ingress__fwd");
#endif

    {
        struct pif_lookup_result result;
        result = pif_lookup(PIF_TABLE_ID_ingress__fwd, _pif_parrep, actbuf, actbuf_off);
        action_id = result.action_id;
        *actlen = result.action_len;
    }

    next_state = PIF_CTLFLOW_STATE_ingress_flow_exit_control_flow; /* always */

    if (*actlen > 0) {
        __critical_path();
        ret = pif_action_execute(_pif_parrep, actbuf, actbuf_off, *actlen);
        if (ret < 0)
            return ret;
        __critical_path();
        if (ret > 0)
            next_state = PIF_CTLFLOW_STATE_ingress_flow_DONE;
        __critical_path();
    }

    *state = next_state;
    return 0;
}

static int handle_ingress_flow__condition_1(__lmem uint32_t *_pif_parrep)
{
    unsigned int pif_expression__condition_1_register_0;
    __lmem struct pif_header_udp *udp;
    __lmem struct pif_parrep_ctldata *prdata = (__lmem struct pif_parrep_ctldata *)(_pif_parrep + PIF_PARREP_CTLDATA_OFF_LW);

#ifdef PIF_DEBUG
    __debug_label("pif_ctlflow_state_ingress_flow__condition_1");
#endif

    udp = (__lmem struct pif_header_udp *) (_pif_parrep + PIF_PARREP_udp_OFF_LW);

    //expression _condition_1: (((((((((valid(ipv4))) and (((udp.dstPort) == (9001))))) or (((udp.dstPort) == (9002))))) or (((udp.dstPort) == (9003))))) or (((udp.dstPort) == (9004))))
    {
    unsigned int pif_expression__condition_1_register_1;
    unsigned int pif_expression__condition_1_register_2;
    unsigned int pif_expression__condition_1_register_3;
    unsigned int pif_expression__condition_1_register_4;
    //subexpression 13: valid(ipv4)
    pif_expression__condition_1_register_0 = PIF_PARREP_ipv4_VALID(prdata);
    //subexpression 16: 9001
    // constant : 0x2329

    //subexpression 14: (udp.dstPort)==(9001)
    pif_expression__condition_1_register_2 = udp->dstPort;
    pif_expression__condition_1_register_3 = 0x2329;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_1_register_4 = pif_expression__condition_1_register_3 & 0x3fff;
    pif_expression__condition_1_register_1 = (pif_expression__condition_1_register_2 == pif_expression__condition_1_register_4);
    //subexpression 9: ((valid(ipv4)))and(((udp.dstPort)==(9001)))
    pif_expression__condition_1_register_4 = (pif_expression__condition_1_register_0) && (pif_expression__condition_1_register_1);
    //subexpression 12: 9002
    // constant : 0x232a

    //subexpression 10: (udp.dstPort)==(9002)
    pif_expression__condition_1_register_0 = udp->dstPort;
    pif_expression__condition_1_register_2 = 0x232a;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_1_register_3 = pif_expression__condition_1_register_2 & 0x3fff;
    pif_expression__condition_1_register_1 = (pif_expression__condition_1_register_0 == pif_expression__condition_1_register_3);
    //subexpression 5: ((((valid(ipv4)))and(((udp.dstPort)==(9001)))))or(((udp.dstPort)==(9002)))
    pif_expression__condition_1_register_3 = pif_expression__condition_1_register_4 || pif_expression__condition_1_register_1;
    //subexpression 8: 9003
    // constant : 0x232b

    //subexpression 6: (udp.dstPort)==(9003)
    pif_expression__condition_1_register_4 = udp->dstPort;
    pif_expression__condition_1_register_0 = 0x232b;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_1_register_2 = pif_expression__condition_1_register_0 & 0x3fff;
    pif_expression__condition_1_register_1 = (pif_expression__condition_1_register_4 == pif_expression__condition_1_register_2);
    //subexpression 1: ((((((valid(ipv4)))and(((udp.dstPort)==(9001)))))or(((udp.dstPort)==(9002)))))or(((udp.dstPort)==(9003)))
    pif_expression__condition_1_register_2 = pif_expression__condition_1_register_3 || pif_expression__condition_1_register_1;
    //subexpression 4: 9004
    // constant : 0x232c

    //subexpression 2: (udp.dstPort)==(9004)
    pif_expression__condition_1_register_3 = udp->dstPort;
    pif_expression__condition_1_register_4 = 0x232c;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_1_register_0 = pif_expression__condition_1_register_4 & 0x3fff;
    pif_expression__condition_1_register_1 = (pif_expression__condition_1_register_3 == pif_expression__condition_1_register_0);
    //subexpression 0: ((((((((valid(ipv4)))and(((udp.dstPort)==(9001)))))or(((udp.dstPort)==(9002)))))or(((udp.dstPort)==(9003)))))or(((udp.dstPort)==(9004)))
    pif_expression__condition_1_register_0 = pif_expression__condition_1_register_2 || pif_expression__condition_1_register_1;
    }

    if (pif_expression__condition_1_register_0)
        return PIF_CTLFLOW_STATE_ingress_flow_ingress__tbl_act;
    else
        return PIF_CTLFLOW_STATE_ingress_flow_ingress__fwd;
}

static int handle_ingress_flow__condition_0(__lmem uint32_t *_pif_parrep)
{
    unsigned int pif_expression__condition_0_register_4;
    __lmem struct pif_header_udp *udp;
    __lmem struct pif_parrep_ctldata *prdata = (__lmem struct pif_parrep_ctldata *)(_pif_parrep + PIF_PARREP_CTLDATA_OFF_LW);

#ifdef PIF_DEBUG
    __debug_label("pif_ctlflow_state_ingress_flow__condition_0");
#endif

    udp = (__lmem struct pif_header_udp *) (_pif_parrep + PIF_PARREP_udp_OFF_LW);

    //expression _condition_0: (((valid(ipv4))) and (((udp.dstPort) == (8000))))
    {
    unsigned int pif_expression__condition_0_register_0;
    unsigned int pif_expression__condition_0_register_1;
    unsigned int pif_expression__condition_0_register_2;
    unsigned int pif_expression__condition_0_register_3;
    //subexpression 1: valid(ipv4)
    pif_expression__condition_0_register_0 = PIF_PARREP_ipv4_VALID(prdata);
    //subexpression 4: 8000
    // constant : 0x1f40

    //subexpression 2: (udp.dstPort)==(8000)
    pif_expression__condition_0_register_2 = udp->dstPort;
    pif_expression__condition_0_register_3 = 0x1f40;
    /* implicit cast 13 -> 16 */
    pif_expression__condition_0_register_4 = pif_expression__condition_0_register_3 & 0x1fff;
    pif_expression__condition_0_register_1 = (pif_expression__condition_0_register_2 == pif_expression__condition_0_register_4);
    //subexpression 0: ((valid(ipv4)))and(((udp.dstPort)==(8000)))
    pif_expression__condition_0_register_4 = (pif_expression__condition_0_register_0) && (pif_expression__condition_0_register_1);
    }

    if (pif_expression__condition_0_register_4)
        return PIF_CTLFLOW_STATE_ingress_flow_ingress__dispatch;
    else
        return PIF_CTLFLOW_STATE_ingress_flow__condition_1;
}

static int handle_ingress_flow_ingress__dispatch(__lmem uint32_t *_pif_parrep, __mem __addr40 uint32_t *actbuf, unsigned int actbuf_off, int *actlen, int *state)
{
    __gpr int action_id, ret;
    int next_state = PIF_CTLFLOW_STATE_ingress_flow_DONE;

#ifdef PIF_DEBUG
    __debug_label("pif_ctlflow_state_ingress_flow_ingress__dispatch");
#endif

    {
        struct pif_lookup_result result;
        result = pif_lookup(PIF_TABLE_ID_ingress__dispatch, _pif_parrep, actbuf, actbuf_off);
        action_id = result.action_id;
        *actlen = result.action_len;
    }

    next_state = PIF_CTLFLOW_STATE_ingress_flow_ingress__fwd; /* always */

    if (*actlen > 0) {
        __critical_path();
        ret = pif_action_execute(_pif_parrep, actbuf, actbuf_off, *actlen);
        if (ret < 0)
            return ret;
        __critical_path();
        if (ret > 0)
            next_state = PIF_CTLFLOW_STATE_ingress_flow_DONE;
        __critical_path();
    }

    *state = next_state;
    return 0;
}

/* Control flow entry point */

int pif_ctlflow_ingress_flow(int *start_state, __lmem uint32_t *_pif_parrep, __mem __addr40 uint32_t *actbuf, unsigned int actbuf_off)
{
    __gpr int actlen, totlen = 0;
    __gpr int ret;
    int pif_ctlflow_state_ingress_flow = PIF_CTLFLOW_STATE_ingress_flow__condition_0;

    while (pif_ctlflow_state_ingress_flow != PIF_CTLFLOW_STATE_ingress_flow_DONE) {
        PIF_DEBUG_SET_STATE(PIF_DEBUG_STATE_CONTROL, ((0 << 16) + pif_ctlflow_state_ingress_flow));
#ifdef PIF_DEBUG
        __debug_label("pif_ctlflow_state_ingress_flow");
#endif
        switch (pif_ctlflow_state_ingress_flow) {
        case PIF_CTLFLOW_STATE_ingress_flow_ingress__tbl_act:
            ret = handle_ingress_flow_ingress__tbl_act(_pif_parrep, actbuf, actbuf_off + totlen, (int *)&actlen, (int *)&pif_ctlflow_state_ingress_flow);
            break;
        case PIF_CTLFLOW_STATE_ingress_flow_ingress__fwd:
            ret = handle_ingress_flow_ingress__fwd(_pif_parrep, actbuf, actbuf_off + totlen, (int *)&actlen, (int *)&pif_ctlflow_state_ingress_flow);
            break;
        case PIF_CTLFLOW_STATE_ingress_flow__condition_1:
            pif_ctlflow_state_ingress_flow = handle_ingress_flow__condition_1(_pif_parrep);
            continue;
        case PIF_CTLFLOW_STATE_ingress_flow__condition_0:
            pif_ctlflow_state_ingress_flow = handle_ingress_flow__condition_0(_pif_parrep);
            continue;
        case PIF_CTLFLOW_STATE_ingress_flow_ingress__dispatch:
            ret = handle_ingress_flow_ingress__dispatch(_pif_parrep, actbuf, actbuf_off + totlen, (int *)&actlen, (int *)&pif_ctlflow_state_ingress_flow);
            break;
        }
        if (actlen < 0) /* error! */
            return actlen & ((~(1 << PIF_LOOKUP_ERROR_BIT)));
        __critical_path();
        totlen += actlen;
        if (ret < 0)
            return -totlen;
    }

    return totlen;
}

/****************************************
 * egress_flow                          *
 ****************************************/

/* State transition functions */

static int handle_egress_flow_egress__tbl_fix_checksum(__lmem uint32_t *_pif_parrep, __mem __addr40 uint32_t *actbuf, unsigned int actbuf_off, int *actlen, int *state)
{
    __gpr int action_id, ret;
    int next_state = PIF_CTLFLOW_STATE_egress_flow_DONE;

#ifdef PIF_DEBUG
    __debug_label("pif_ctlflow_state_egress_flow_egress__tbl_fix_checksum");
#endif

    {
        struct pif_action_actiondata_egress__fix_checksum actdata;
        __xwrite struct {
            union pif_action_opdata opdata;
            struct pif_action_actiondata_egress__fix_checksum actdata;
            } wr_buf;

        wr_buf.opdata.val32 = (PIF_ACTION_ID_egress__fix_checksum << PIF_ACTION_OPDATA_ACTION_ID_off) | ((sizeof(actdata) / 4) << PIF_ACTION_OPDATA_ACTDATA_CNT_off);
        actdata.__pif_table_no = 0xffffffff;
        actdata.__pif_rule_no = 0x0;
        wr_buf.actdata = actdata;

        mem_write32(&wr_buf,
                    actbuf + actbuf_off,
                    sizeof(wr_buf));
        *actlen = sizeof(wr_buf)/4;
    }

    next_state = PIF_CTLFLOW_STATE_egress_flow_exit_control_flow; /* always */

    if (*actlen > 0) {
        __critical_path();
        ret = pif_action_execute(_pif_parrep, actbuf, actbuf_off, *actlen);
        if (ret < 0)
            return ret;
        __critical_path();
        if (ret > 0)
            next_state = PIF_CTLFLOW_STATE_egress_flow_DONE;
        __critical_path();
    }

    *state = next_state;
    return 0;
}

static int handle_egress_flow__condition_2(__lmem uint32_t *_pif_parrep)
{
    unsigned int pif_expression__condition_2_register_0;
    __lmem struct pif_header_udp *udp;

#ifdef PIF_DEBUG
    __debug_label("pif_ctlflow_state_egress_flow__condition_2");
#endif

    udp = (__lmem struct pif_header_udp *) (_pif_parrep + PIF_PARREP_udp_OFF_LW);

    //expression _condition_2: ((((((((((udp.dstPort) == (8000))) or (((udp.dstPort) == (9001))))) or (((udp.dstPort) == (9002))))) or (((udp.dstPort) == (9003))))) or (((udp.dstPort) == (9004))))
    {
    unsigned int pif_expression__condition_2_register_1;
    unsigned int pif_expression__condition_2_register_2;
    unsigned int pif_expression__condition_2_register_3;
    unsigned int pif_expression__condition_2_register_4;
    //subexpression 18: 8000
    // constant : 0x1f40

    //subexpression 13: (udp.dstPort)==(8000)
    pif_expression__condition_2_register_1 = udp->dstPort;
    pif_expression__condition_2_register_2 = 0x1f40;
    /* implicit cast 13 -> 16 */
    pif_expression__condition_2_register_3 = pif_expression__condition_2_register_2 & 0x1fff;
    pif_expression__condition_2_register_0 = (pif_expression__condition_2_register_1 == pif_expression__condition_2_register_3);
    //subexpression 16: 9001
    // constant : 0x2329

    //subexpression 14: (udp.dstPort)==(9001)
    pif_expression__condition_2_register_1 = udp->dstPort;
    pif_expression__condition_2_register_2 = 0x2329;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_2_register_4 = pif_expression__condition_2_register_2 & 0x3fff;
    pif_expression__condition_2_register_3 = (pif_expression__condition_2_register_1 == pif_expression__condition_2_register_4);
    //subexpression 9: (((udp.dstPort)==(8000)))or(((udp.dstPort)==(9001)))
    pif_expression__condition_2_register_4 = pif_expression__condition_2_register_0 || pif_expression__condition_2_register_3;
    //subexpression 12: 9002
    // constant : 0x232a

    //subexpression 10: (udp.dstPort)==(9002)
    pif_expression__condition_2_register_0 = udp->dstPort;
    pif_expression__condition_2_register_1 = 0x232a;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_2_register_2 = pif_expression__condition_2_register_1 & 0x3fff;
    pif_expression__condition_2_register_3 = (pif_expression__condition_2_register_0 == pif_expression__condition_2_register_2);
    //subexpression 5: (((((udp.dstPort)==(8000)))or(((udp.dstPort)==(9001)))))or(((udp.dstPort)==(9002)))
    pif_expression__condition_2_register_2 = pif_expression__condition_2_register_4 || pif_expression__condition_2_register_3;
    //subexpression 8: 9003
    // constant : 0x232b

    //subexpression 6: (udp.dstPort)==(9003)
    pif_expression__condition_2_register_4 = udp->dstPort;
    pif_expression__condition_2_register_0 = 0x232b;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_2_register_1 = pif_expression__condition_2_register_0 & 0x3fff;
    pif_expression__condition_2_register_3 = (pif_expression__condition_2_register_4 == pif_expression__condition_2_register_1);
    //subexpression 1: (((((((udp.dstPort)==(8000)))or(((udp.dstPort)==(9001)))))or(((udp.dstPort)==(9002)))))or(((udp.dstPort)==(9003)))
    pif_expression__condition_2_register_1 = pif_expression__condition_2_register_2 || pif_expression__condition_2_register_3;
    //subexpression 4: 9004
    // constant : 0x232c

    //subexpression 2: (udp.dstPort)==(9004)
    pif_expression__condition_2_register_2 = udp->dstPort;
    pif_expression__condition_2_register_4 = 0x232c;
    /* implicit cast 14 -> 16 */
    pif_expression__condition_2_register_0 = pif_expression__condition_2_register_4 & 0x3fff;
    pif_expression__condition_2_register_3 = (pif_expression__condition_2_register_2 == pif_expression__condition_2_register_0);
    //subexpression 0: (((((((((udp.dstPort)==(8000)))or(((udp.dstPort)==(9001)))))or(((udp.dstPort)==(9002)))))or(((udp.dstPort)==(9003)))))or(((udp.dstPort)==(9004)))
    pif_expression__condition_2_register_0 = pif_expression__condition_2_register_1 || pif_expression__condition_2_register_3;
    }

    if (pif_expression__condition_2_register_0)
        return PIF_CTLFLOW_STATE_egress_flow_egress__tbl_fix_checksum;
    else
        return PIF_CTLFLOW_STATE_egress_flow_exit_control_flow;
}

/* Control flow entry point */

int pif_ctlflow_egress_flow(int *start_state, __lmem uint32_t *_pif_parrep, __mem __addr40 uint32_t *actbuf, unsigned int actbuf_off)
{
    __gpr int actlen, totlen = 0;
    __gpr int ret;
    int pif_ctlflow_state_egress_flow = PIF_CTLFLOW_STATE_egress_flow__condition_2;

    while (pif_ctlflow_state_egress_flow != PIF_CTLFLOW_STATE_egress_flow_DONE) {
        PIF_DEBUG_SET_STATE(PIF_DEBUG_STATE_CONTROL, ((1 << 16) + pif_ctlflow_state_egress_flow));
#ifdef PIF_DEBUG
        __debug_label("pif_ctlflow_state_egress_flow");
#endif
        switch (pif_ctlflow_state_egress_flow) {
        case PIF_CTLFLOW_STATE_egress_flow_egress__tbl_fix_checksum:
            ret = handle_egress_flow_egress__tbl_fix_checksum(_pif_parrep, actbuf, actbuf_off + totlen, (int *)&actlen, (int *)&pif_ctlflow_state_egress_flow);
            break;
        case PIF_CTLFLOW_STATE_egress_flow__condition_2:
            pif_ctlflow_state_egress_flow = handle_egress_flow__condition_2(_pif_parrep);
            continue;
        }
        if (actlen < 0) /* error! */
            return actlen & ((~(1 << PIF_LOOKUP_ERROR_BIT)));
        __critical_path();
        totlen += actlen;
        if (ret < 0)
            return -totlen;
    }

    return totlen;
}
