/* Copyright (C) 2015-2016,  Netronome Systems, Inc.  All rights reserved. */

#ifndef __PIF_PLUGIN_MAP_HDR_H__
#define __PIF_PLUGIN_MAP_HDR_H__

/* This file is generated, edit at your peril */

/*
 * Header type definition
 */

/* map_hdr (25B) */
struct pif_plugin_map_hdr {
    unsigned int chain_id:32;
    unsigned int exec_id:32;
    unsigned int function_id:32;
    unsigned int data:32;
    unsigned int function_count:32;
    unsigned int f0:8;
    unsigned int f1:8;
    unsigned int f2:8;
    unsigned int f3:8;
    unsigned int f4:8;
};

/* map_hdr field accessor macros */
#define PIF_HEADER_GET_map_hdr___chain_id(_hdr_p) (((_hdr_p)->chain_id)) /* map_hdr.chain_id [32;0] */

#define PIF_HEADER_SET_map_hdr___chain_id(_hdr_p, _val) \
    do { \
        (_hdr_p)->chain_id = (unsigned)(((_val))); \
    } while (0) /* map_hdr.chain_id[32;0] */

#define PIF_HEADER_GET_map_hdr___exec_id(_hdr_p) (((_hdr_p)->exec_id)) /* map_hdr.exec_id [32;0] */

#define PIF_HEADER_SET_map_hdr___exec_id(_hdr_p, _val) \
    do { \
        (_hdr_p)->exec_id = (unsigned)(((_val))); \
    } while (0) /* map_hdr.exec_id[32;0] */

#define PIF_HEADER_GET_map_hdr___function_id(_hdr_p) (((_hdr_p)->function_id)) /* map_hdr.function_id [32;0] */

#define PIF_HEADER_SET_map_hdr___function_id(_hdr_p, _val) \
    do { \
        (_hdr_p)->function_id = (unsigned)(((_val))); \
    } while (0) /* map_hdr.function_id[32;0] */

#define PIF_HEADER_GET_map_hdr___data(_hdr_p) (((_hdr_p)->data)) /* map_hdr.data [32;0] */

#define PIF_HEADER_SET_map_hdr___data(_hdr_p, _val) \
    do { \
        (_hdr_p)->data = (unsigned)(((_val))); \
    } while (0) /* map_hdr.data[32;0] */

#define PIF_HEADER_GET_map_hdr___function_count(_hdr_p) (((_hdr_p)->function_count)) /* map_hdr.function_count [32;0] */

#define PIF_HEADER_SET_map_hdr___function_count(_hdr_p, _val) \
    do { \
        (_hdr_p)->function_count = (unsigned)(((_val))); \
    } while (0) /* map_hdr.function_count[32;0] */

#define PIF_HEADER_GET_map_hdr___f0(_hdr_p) (((_hdr_p)->f0)) /* map_hdr.f0 [8;0] */

#define PIF_HEADER_SET_map_hdr___f0(_hdr_p, _val) \
    do { \
        (_hdr_p)->f0 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f0[8;0] */

#define PIF_HEADER_GET_map_hdr___f1(_hdr_p) (((_hdr_p)->f1)) /* map_hdr.f1 [8;0] */

#define PIF_HEADER_SET_map_hdr___f1(_hdr_p, _val) \
    do { \
        (_hdr_p)->f1 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f1[8;0] */

#define PIF_HEADER_GET_map_hdr___f2(_hdr_p) (((_hdr_p)->f2)) /* map_hdr.f2 [8;0] */

#define PIF_HEADER_SET_map_hdr___f2(_hdr_p, _val) \
    do { \
        (_hdr_p)->f2 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f2[8;0] */

#define PIF_HEADER_GET_map_hdr___f3(_hdr_p) (((_hdr_p)->f3)) /* map_hdr.f3 [8;0] */

#define PIF_HEADER_SET_map_hdr___f3(_hdr_p, _val) \
    do { \
        (_hdr_p)->f3 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f3[8;0] */

#define PIF_HEADER_GET_map_hdr___f4(_hdr_p) (((_hdr_p)->f4)) /* map_hdr.f4 [8;0] */

#define PIF_HEADER_SET_map_hdr___f4(_hdr_p, _val) \
    do { \
        (_hdr_p)->f4 = (unsigned)(((_val))); \
    } while (0) /* map_hdr.f4[8;0] */



#define PIF_PLUGIN_map_hdr_T __lmem struct pif_plugin_map_hdr

/*
 * Access function prototypes
 */

int pif_plugin_hdr_map_hdr_present(EXTRACTED_HEADERS_T *extracted_headers);

PIF_PLUGIN_map_hdr_T *pif_plugin_hdr_get_map_hdr(EXTRACTED_HEADERS_T *extracted_headers);

PIF_PLUGIN_map_hdr_T *pif_plugin_hdr_readonly_get_map_hdr(EXTRACTED_HEADERS_T *extracted_headers);

int pif_plugin_hdr_map_hdr_add(EXTRACTED_HEADERS_T *extracted_headers);

int pif_plugin_hdr_map_hdr_remove(EXTRACTED_HEADERS_T *extracted_headers);






/*
 * Access function implementations
 */

#include "pif_parrep.h"

__forceinline int pif_plugin_hdr_map_hdr_present(EXTRACTED_HEADERS_T *extracted_headers)
{
    __lmem struct pif_parrep_ctldata *_ctl = (__lmem struct pif_parrep_ctldata *)extracted_headers;
    return PIF_PARREP_map_hdr_VALID(_ctl);
}

__forceinline PIF_PLUGIN_map_hdr_T *pif_plugin_hdr_get_map_hdr(EXTRACTED_HEADERS_T *extracted_headers)
{
    __lmem struct pif_parrep_ctldata *_ctl = (__lmem struct pif_parrep_ctldata *)extracted_headers;
    PIF_PARREP_SET_map_hdr_DIRTY(_ctl);
    return (PIF_PLUGIN_map_hdr_T *)(((__lmem uint32_t *)extracted_headers) + PIF_PARREP_map_hdr_OFF_LW);
}

__forceinline PIF_PLUGIN_map_hdr_T *pif_plugin_hdr_readonly_get_map_hdr(EXTRACTED_HEADERS_T *extracted_headers)
{
    __lmem struct pif_parrep_ctldata *_ctl = (__lmem struct pif_parrep_ctldata *)extracted_headers;
    return (PIF_PLUGIN_map_hdr_T *)(((__lmem uint32_t *)extracted_headers) + PIF_PARREP_map_hdr_OFF_LW);
}

__forceinline int pif_plugin_hdr_map_hdr_add(EXTRACTED_HEADERS_T *extracted_headers)
{
    return -1; /* this header is not addable in the P4 design */
}

__forceinline int pif_plugin_hdr_map_hdr_remove(EXTRACTED_HEADERS_T *extracted_headers)
{
    return -1; /* this header is not removable in the P4 design */
}

#endif /* __PIF_PLUGIN_MAP_HDR_H__ */
