#define ROUTER_HASH_WIDTH  8

header_type router_t {
    fields {
        router_index: 8;
    }
}

metadata router_t router;

action update_dst_act(dstAddr) {
    modify_field (ipv4.dstAddr, dstAddr);
    modify_field (udp.dstPort, NC_PORT);
}

table update_dst {
    reads {
        router.router_index: exact;
    }
    actions {
        update_dst_act;
    }
}

field_list router_hash_fields {
    router_hdr.key;
}

field_list_calculation router_hash {
    input {
        router_hash_fields;
    }
    algorithm : crc32;
    output_width : ROUTER_HASH_WIDTH;
}

action calculate_router_hash_act() {
    modify_field_with_hash_based_offset(router.router_index, 0, router_hash, CLUSTER_COUNT);
}

table calculate_router_hash {
    actions {
        calculate_router_hash_act;
    }
}

control routePacket {
    apply(calculate_router_hash);
    apply(update_dst);
}
