struct resubmit_meta_t {
    bit<8> current_state;
    bit<32> data;
}

struct ingress_metadata_t {
    bit<1> drop;
    bit<9> egress_port;
    bit<4> packet_type;
}

header ethernet_t {
    bit<48> dstAddr;
    bit<48> srcAddr;
    bit<16> etherType;
}

header ipv4_t {
    bit<4>  version;
    bit<4>  ihl;
    bit<8>  diffserv;
    bit<16> totalLen;
    bit<16> identification;
    bit<3>  flags;
    bit<13> fragOffset;
    bit<8>  ttl;
    bit<8>  protocol;
    bit<16> hdrChecksum;
    bit<32> srcAddr;
    bit<32> dstAddr;
}

header udp_t {
    bit<16> srcPort;
    bit<16> dstPort;
    bit<16> length_;
    bit<16> checksum;
}

header map_hdr_t {
    bit<32> chain_id;
    bit<32> exec_id;
    bit<8> function_id;
    bit<32> data;
    bit<8> function_count;
    bit<8>  f0;
    bit<8>  f1;
    bit<8>  f2;
    bit<8>  f3;
    bit<8>  f4;
}

struct exec_hdr_t {
    bit<8> function_count;
    bit<8>  function;
}

struct metadata {
    @name(".ing_metadata") 
    ingress_metadata_t ing_metadata;
    @name(".resubmit_meta") 
    resubmit_meta_t resubmit_meta;
    @name(".exec_hdr")
    exec_hdr_t exec_hdr;
}

struct headers {
    @name(".ethernet") 
    ethernet_t ethernet;
    @name(".ipv4") 
    ipv4_t     ipv4;
    @name(".udp") 
    udp_t      udp;
    @name(".map_hdr") 
    map_hdr_t map_hdr;
}