const constants = require('./constants_local.json')
const util = require('util')
let kafka = require('kafka-node'),
    Producer = kafka.Producer,
    client = new kafka.KafkaClient({
        kafkaHost: constants.network.external.kafka_host,
        autoConnect: true
    }),
    producer = new Producer(client),
    Consumer = kafka.Consumer,
    consumer = new Consumer(client,
        [
            { topic: constants.topics.log_channel }
        ])

consumer.on('message', function (message) {
    message = JSON.parse(message.value)
    console.log(util.inspect(message, false, null, true /* enable colors */))
    
})
