const secrets = require('./secrets.json')
const constants = require('.././constants_local.json')

let db = new Map(), // queue holding request to be dispatched
    resourceMap = new Map(), // map between resource_id and resource details like node_id, port, associated function etc
    functionToResource = new Map(), // a function to resource map. Each map contains a minheap of
                                    // resources associated with the function
    workerNodes = new Map(), // list of worker nodes currently known to the DM
    functionBranchTree = new Map(), // a tree to store function branch predictions
    conditionProbabilityExplicit = new Map(), // tree holding conditional probabilities for explicit chains
    requestFlightQueue = new Map(), // map to store in flight requests
    idToFunchashmap = new Map(), // map to keep function hash corresponding to function id sent by client
    resource_to_cpu_util = new Map(),
    node_to_resource_mapping = new Map()


/**
 * URL to the couchdb database server used to store data
 */

let metadataDB = `http://${secrets.couchdb_username}:${secrets.couchdb_password}@${constants.couchdb_host}`
metadataDB = metadataDB + "/" + constants.db.function_meta + "/"

console.log("metadata : "+metadataDB)

let metricsDB = `http://${secrets.couchdb_username}:${secrets.couchdb_password}@${constants.couchdb_host}`
metricsDB = metricsDB + "/" + constants.db.metrics + "/"

let implicitChainDB = `http://${secrets.couchdb_username}:${secrets.couchdb_password}@${constants.couchdb_host}`
implicitChainDB = implicitChainDB + "/" + constants.db.implicit_chain_meta + "/"

let explicitChainDB = `http://${secrets.couchdb_username}:${secrets.couchdb_password}@${constants.couchdb_host}`
explicitChainDB = explicitChainDB + "/" + constants.db.explicit_chain_meta + "/"

module.exports = {
    db, functionBranchTree, functionToResource, workerNodes, resourceMap,
    conditionProbabilityExplicit, requestFlightQueue,
    metadataDB, metricsDB, implicitChainDB, explicitChainDB, idToFunchashmap, resource_to_cpu_util, node_to_resource_mapping
}
