// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/* eslint-disable no-undef,no-console,block-scoped-var */
'use strict';
var KafkaDataProducer = require('../index').KafkaDataProducer;
var ProducerRecord = require('../index').ProducerRecord;
var Buffer = require('buffer').Buffer;

var configs2 = {
    clientType: 'AtLeastOnce',
    proxyHost: 'localhost',
    proxyPort: 8080,
    proxyRefreshTime: 0,
    timeout: 2000,
    localAgentMode: 'ALWAYS'
};

function onConnect(err) {
    if (!err) {
        console.log('KafkaRestClient connected to kafka');
    } else {
        console.log('KafkaRestClient could not connect to kafka');
    }
}

function msgCallback(err, res) {
    if (err) {
        console.log(err);
    } else {
        console.log(res);
    }
}

var kp = new KafkaDataProducer(configs2);
kp.connect(onConnect);

var buf = new Buffer('Simply Easy Learning', 'utf-8');

setTimeout(function close() {
    kp.produceSync('test_hongxu', new ProducerRecord({key: buf, value: 'value'}), msgCallback);
}, 1000);

setTimeout(function close() {
    kp.close();
}, 3000);
/* eslint-enable no-undef,no-console,block-scoped-var */

