#include "includes/defines.p4"
#include "includes/headers.p4"
#include "includes/parsers.p4"
#include "includes/checksum.p4"
#include "ethernet.p4"
#include "ipv4.p4"

#define PKT_INSTANCE_TYPE_NORMAL 0
#define PKT_INSTANCE_TYPE_INGRESS_CLONE 1
#define PKT_INSTANCE_TYPE_EGRESS_CLONE 2
#define PKT_INSTANCE_TYPE_COALESCED 3
#define PKT_INSTANCE_TYPE_INGRESS_RECIRC 4
#define PKT_INSTANCE_TYPE_REPLICATION 5
#define PKT_INSTANCE_TYPE_RESUBMIT 6


register runtime {
    width: 8;
    instance_count: 1000;
}

header_type resubmit_meta_t {
    fields {
        resubmit_key: 32;
    }
}

metadata resubmit_meta_t resubmit_meta;

field_list resubmit_metadata {
    resubmit_meta.resubmit_key;
}

action _resubmit_act() {
    resubmit(resubmit_metadata);
}

table _resubmit{
    actions {
        _resubmit_act;
    }
}

action copy_meta_act() {
    modify_field(router_hdr.key, resubmit_meta.resubmit_key);
}

table copy_meta {
    actions {
        copy_meta_act;
    }
}


action increase_act() {
    add_to_field(resubmit_meta.resubmit_key, 1);
    modify_field(router_hdr.key, resubmit_meta.resubmit_key);
}

table increase {
    actions {
        increase_act;
    }
}

control ingress {
    if ((resubmit_meta.resubmit_key == 0 and router_hdr.f1 == 1) or (resubmit_meta.resubmit_key == 1 and router_hdr.f2 == 1)) {
        apply(increase);
        apply(_resubmit);
    }
    // else if (resubmit_meta.resubmit_key == 2 and router_hdr.f3 == 1) {
    //     apply(increase);
    //     apply(_resubmit);
    // }
    // else if (resubmit_meta.resubmit_key == 3 and router_hdr.f4 == 1) {
    //     apply(increase);
    //     apply(_resubmit);
    // }
    // else if (resubmit_meta.resubmit_key == 4 and router_hdr.f5 == 1) {
    //     apply(increase);
    //     apply(_resubmit);
     else {
        apply(copy_meta);
        apply(ipv4_route);
    }
}
control egress {
    apply(ethernet_set_mac);
}