//=============================================================================================================
#include <stdint.h>
// #include <include/nfp6000/nfp_me.h>
// #include <lib/nfp/mem_atomic.h>

#include <nfp/me.h>
#include <nfp/mem_atomic.h>
#include <pif_common.h>
#include "pif_plugin.h"

//=============================================================================================================

int pif_plugin_prime(EXTRACTED_HEADERS_T *headers, MATCH_DATA_T *match_data) {

    PIF_PLUGIN_map_hdr_T *mapHdr = pif_plugin_hdr_get_map_hdr(headers);
    __gpr uint32_t i = 1;
    uint32_t prime = mapHdr->data;
    uint32_t j = 2;
    uint32_t x = 1;
    __gpr uint32_t calc_prime = 1;
    short b = 0;
    for (;i < prime; i++) {
        b = 0;
        for (j = 2; j <= (i / 2); j++)  {
            if (i % j == 0) {
                b = 1;
                break;
            }
        }
        if (b == 0)
            calc_prime = i;
    }
    
    mapHdr->data = prime;
    return PIF_PLUGIN_RETURN_FORWARD; 
}