#include <core.p4>
#define V1MODEL_VERSION 20200408
#include <v1model.p4>
#include "includes/defines.p4"
#include "includes/headers.p4"
#include "includes/parsers.p4"

//extern void prime();
//extern void prime2();

extern void static_dispatch_function();

//extern void countpacket();

//struct digest_t {
   // bit<32> index;
  //  bit<48> dstAddr;
   // bit<48> srcAddr;
    //bit<16> etherType;   
//}
//struct digest_time_t {
  //  bit<64> igt;
   // bit<64> cgt;   
   // bit<64> time_taken;
//}
//struct digest_t2 {
  //  bit<32> req_fid;
//}

struct digest_check_udp_port{
    bit<16> udp_port;
    bit<32> fid;
    bit<4> packet_count;
    bit<32> src_ip;
    bit<32> dst_ip;
}
control ingress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    //register<bit<8>>(10000) function_id_check; 
    register<bit<4>>(1) fwd_checks; 
    //bit<8> pc;
    bit<4> pc2=0;
    bit<1> static=1w1;

    @name(".fwd_act") action fwd_act(bit<16> port) {
        standard_metadata.egress_spec = port;
    }

    @name(".fwd") table fwd {
        actions = {
            fwd_act;
        }
        key = {
            standard_metadata.ingress_port : exact;
        }
    }

    @name(".dispatch_act") action dispatch_act(bit<32> dstAddr, bit<16> dstPort, bit<48> ethernetAddr , bit<16> egress_port) {
        hdr.ipv4.dstAddr = dstAddr;
        hdr.udp.dstPort = dstPort;
        hdr.ethernet.dstAddr = ethernetAddr;


        //digest_t d0;

        
        //d0.srcAddr = hdr.ethernet.srcAddr;
        //d0.dstAddr = hdr.ethernet.dstAddr;
        //d0.etherType = hdr.ethernet.etherType;
        //digest<digest_t>(0, d0 );
        
        //prime();
    }

    @name(".prime1_act") action prime1_act(bit<32> dstAddr, bit<16> dstPort, bit<48> ethernetAddr , bit<16> egress_port) {
        hdr.ipv4.dstAddr = dstAddr;
        hdr.udp.dstPort = dstPort;
        hdr.ethernet.dstAddr = ethernetAddr;
        //prime();
    }

    @name(".prime2_act") action prime2_act(bit<32> dstAddr, bit<16> dstPort, bit<48> ethernetAddr , bit<16> egress_port) {
        hdr.ipv4.dstAddr = dstAddr;
        hdr.udp.dstPort = dstPort;
        hdr.ethernet.dstAddr = ethernetAddr;
        //prime2();
    }

    @name(".swap_addr") action swap_addr() {
        //swap ethernet address
        bit<48> temp = hdr.ethernet.srcAddr;
        hdr.ethernet.srcAddr = hdr.ethernet.dstAddr;
        hdr.ethernet.dstAddr = temp;

        // swap ipv4
        bit<32> tmp = hdr.ipv4.srcAddr;
        hdr.ipv4.srcAddr = hdr.ipv4.dstAddr;
        hdr.ipv4.dstAddr = tmp;

        // change udp
        //bit<16> val = 10001;
        hdr.udp.srcPort = hdr.udp.dstPort;
        //hdr.udp.dstPort = val;

        // change vf 
        standard_metadata.ingress_port = 769;

        //prime2();
    }
    

    @name(".dispatch") table dispatch {
        actions = {
            dispatch_act;
            prime1_act;
            prime2_act;
        }
        key = {
            hdr.map_hdr.function_id : exact;
        }
    }
    apply {
        if (hdr.ipv4.isValid() && hdr.udp.dstPort == DISPATCHER_PORT) {
            //function_id_check.read(pc,0);
            //pc = 8w2;
            //pc = hdr.map_hdr.function_id;
            //function_id_check.write(0,pc);
           
            dispatch.apply();
            
            //countpacket();
            //digest_t2 d2;
            //digest<digest_t2>(0, d2 );
            //digest_time_t dtime;
            //dtime.igt = meta.intrinsic_metadata.ingress_global_timestamp;
            //dtime.cgt = meta.intrinsic_metadata.current_global_timestamp;
            //dtime.time_taken = dtime.cgt - dtime.igt;
            //digest<digest_time_t>(0, dtime );
            //if(static == 1w1 && hdr.udp.dstPort != 8080)

            fwd_checks.read(pc2,0);
            pc2 = pc2 + 1;
            

            if(hdr.udp.dstPort != 8080 )
            {
                static_dispatch_function();
                //bit<32> var=32w21;
                if(hdr.map_hdr.data == EXEC_ON_NIC)
                {
                    swap_addr();
                    //hdr.map_hdr.data=var;
                }
            }
            
            fwd_checks.write(0,pc2);
            digest_check_udp_port dig;
            dig.udp_port = hdr.udp.dstPort;
            dig.fid = hdr.map_hdr.data;
            dig.packet_count = pc2;
            dig.src_ip = hdr.ipv4.srcAddr;
            dig.dst_ip = hdr.ipv4.dstAddr;
            digest<digest_check_udp_port>(0, dig );
                
            fwd.apply();

        } else {
            fwd.apply();
        }
        
        //bit<16>mod = 16w10;
        //hdr.udp.dstPort = 10000+(pc2 % mod);
        
        
    }
}

control egress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    // @name(".ethernet_set_mac_act") action ethernet_set_mac_act(bit<48> smac, bit<48> dmac) {
    //     hdr.ethernet.srcAddr = smac;
    //     hdr.ethernet.dstAddr = dmac;
    // }
    // @name(".ethernet_set_mac") table ethernet_set_mac {
    //     actions = {
    //         ethernet_set_mac_act;
    //     }
    //     key = {
    //         standard_metadata.egress_port: exact;
    //     }
    // }

    @name("fix_checksum") action fix_checksum() {
        hdr.udp.checksum = 16w0;
    }
  

    apply {
        // if (hdr.udp.dstPort == MDS_PORT) {           
        //     ethernet_set_mac.apply();
        // }
        fix_checksum();
    }
}

control DeparserImpl(packet_out packet, in headers hdr) {
    apply {
        packet.emit<ethernet_t>(hdr.ethernet);
        packet.emit<ipv4_t>(hdr.ipv4);
        packet.emit<udp_t>(hdr.udp);
        packet.emit<map_hdr_t>(hdr.map_hdr);
    }
}

control verifyChecksum(inout headers hdr, inout metadata meta) {
    apply {
        verify_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

control computeChecksum(inout headers hdr, inout metadata meta) {
    apply {
        update_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

V1Switch<headers, metadata>(ParserImpl(), verifyChecksum(), ingress(), egress(), computeChecksum(), DeparserImpl()) main;
