#include <core.p4>
#define V1MODEL_VERSION 20200408
#include <v1model.p4> 
#include "includes/defines.p4"
#include "includes/headers.p4"
#include "includes/parsers.p4"

extern void prime();

control ingress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    @name(".fwd_act") action fwd_act(bit<16> port) {
        standard_metadata.egress_spec = port;
    }

    @name(".fwd") table fwd {
        actions = {
            fwd_act;
        }
        key = {
            standard_metadata.ingress_port : exact;
        }
    }

    @name(".dispatch_act") action dispatch_act(bit<32> dstAddr, bit<16> dstPort, bit<48> ethernetAddr , bit<16> egress_port) {
        hdr.ipv4.dstAddr = dstAddr;
        hdr.udp.dstPort = dstPort;
        hdr.ethernet.dstAddr = ethernetAddr;
    }

    @name(".dispatch") table dispatch {
        actions = {
            dispatch_act;
        }
        key = {
            hdr.map_hdr.function_id : exact;
        }
    }

    @name("circleBack") action circleBack() {
        bit<32> tempAddr = hdr.ipv4.dstAddr;
        hdr.ipv4.dstAddr = hdr.ipv4.srcAddr;
        hdr.ipv4.srcAddr = tempAddr;
        bit<16> tempPort = hdr.udp.dstPort;
        hdr.udp.dstPort = hdr.udp.srcPort;
        hdr.udp.srcPort = tempPort;
        bit<48> tempEth = hdr.ethernet.dstAddr;
        hdr.ethernet.dstAddr = hdr.ethernet.srcAddr;
        hdr.ethernet.srcAddr = tempEth;
        standard_metadata.egress_spec = standard_metadata.ingress_port;
        hdr.ipv4.ttl = hdr.ipv4.ttl - 8w1;
    }
 
    apply {
        if (hdr.ipv4.isValid() && hdr.udp.dstPort == DISPATCHER_PORT) {
            dispatch.apply();
            fwd.apply();
        } else if (hdr.ipv4.isValid() && hdr.udp.dstPort == 9001 || hdr.udp.dstPort == 9002 ||  
                hdr.udp.dstPort == 9003 || hdr.udp.dstPort == 9004 || hdr.udp.dstPort == 9005 || hdr.udp.dstPort == 9006 || hdr.udp.dstPort == 9007 ) {
            // if (hdr.map_hdr.function_count != 8w0) {
                clone3(CloneType.I2E, 32w1, standard_metadata);
            // } 
            // hdr.map_hdr.function_count = 8w0;
            fwd.apply();
            
        } else if (hdr.udp.dstPort == SPEEDO_REPLY_PORT) {
            if (hdr.map_hdr.function_id < hdr.map_hdr.function_count) {
                hdr.map_hdr.function_id = hdr.map_hdr.function_id + 8w1;
                circleBack();
                clone3(CloneType.I2E, 32w1, standard_metadata);
            } else {
                fwd.apply();
            }
        } else {
            fwd.apply();
        }
    }
}

control egress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    // @name(".ethernet_set_mac_act") action ethernet_set_mac_act(bit<48> smac, bit<48> dmac) {
    //     hdr.ethernet.srcAddr = smac;
    //     hdr.ethernet.dstAddr = dmac;
    // }
    // @name(".ethernet_set_mac") table ethernet_set_mac {
    //     actions = {
    //         ethernet_set_mac_act;
    //     }
    //     key = {
    //         standard_metadata.egress_port: exact;
    //     }
    // }

    @name("fix_checksum") action fix_checksum() {
        hdr.udp.checksum = 16w0;
    }
  

    apply {
        // if (hdr.udp.dstPort == MDS_PORT) {           
        //     ethernet_set_mac.apply();
        // }
        if (hdr.udp.dstPort == DISPATCHER_PORT || hdr.udp.dstPort == 9001 || hdr.udp.dstPort == 9002 ||  
                hdr.udp.dstPort == 9003 || hdr.udp.dstPort == 9004 || hdr.udp.dstPort == 9005 || hdr.udp.dstPort == 9006 || hdr.udp.dstPort == 9007 ) {
            fix_checksum();
        }
    }
}

control DeparserImpl(packet_out packet, in headers hdr) {
    apply {
        packet.emit<ethernet_t>(hdr.ethernet);
        packet.emit<ipv4_t>(hdr.ipv4);
        // packet.emit<tcp_t>(hdr.tcp);
        packet.emit<udp_t>(hdr.udp);
        packet.emit<map_hdr_t>(hdr.map_hdr);
    }
}

control verifyChecksum(inout headers hdr, inout metadata meta) {
    apply {
        verify_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

control computeChecksum(inout headers hdr, inout metadata meta) {
    apply {
        update_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

V1Switch<headers, metadata>(ParserImpl(), verifyChecksum(), ingress(), egress(), computeChecksum(), DeparserImpl()) main;
