#include <core.p4>
#define V1MODEL_VERSION 20200408
#include <v1model.p4>
#include "includes/defines.p4"
#include "includes/headers.p4"
#include "includes/parsers.p4"

//extern void prime();
//extern void prime2();

control ingress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    register<bit<8>>(1) function_id_check; 
    register<bit<64>>(1) fwd_checks; 
    bit<8> pc;
    bit<64> pc2;

    @name(".fwd_act") action fwd_act(bit<16> port) {
        standard_metadata.egress_spec = port;
    }

    @name(".fwd") table fwd {
        actions = {
            fwd_act;
        }
        key = {
            standard_metadata.ingress_port : exact;
        }
    }

    @name(".dispatch_act") action dispatch_act(bit<32> dstAddr, bit<16> dstPort, bit<48> ethernetAddr , bit<16> egress_port) {
        hdr.ipv4.dstAddr = dstAddr;
        hdr.udp.dstPort = dstPort;
        hdr.ethernet.dstAddr = ethernetAddr;
        standard_metadata.egress_spec = egress_port;
        //prime();
    }
    @name(".prime1_act") action prime1_act(bit<32> dstAddr, bit<16> dstPort, bit<48> ethernetAddr , bit<16> egress_port) {
        hdr.ipv4.dstAddr = dstAddr;
        hdr.udp.dstPort = dstPort;
        hdr.ethernet.dstAddr = ethernetAddr;
        //prime();
    }
    @name(".prime2_act") action prime2_act(bit<32> dstAddr, bit<16> dstPort, bit<48> ethernetAddr , bit<16> egress_port) {
        hdr.ipv4.dstAddr = dstAddr;
        hdr.udp.dstPort = dstPort;
        hdr.ethernet.dstAddr = ethernetAddr;
        //prime2();
    }
    

    @name(".dispatch") table dispatch {
        actions = {
            dispatch_act;
            //prime1_act;
            //prime2_act;
        }
        key = {
            hdr.map_hdr.function_id : exact;
        }
    }
    apply {
        if (hdr.ipv4.isValid() && hdr.udp.dstPort == DISPATCHER_PORT) {
            //function_id_check.read(pc,0);
            //pc = 8w2;
            //pc = hdr.map_hdr.function_id;
            //function_id_check.write(0,pc);
            dispatch.apply();
            //fwd.apply();
        } else {
            fwd.apply();
        }
        fwd_checks.read(pc2,0);
        pc2 = pc2 + 1;
        fwd_checks.write(0,pc2);
    }
}

control egress(inout headers hdr, inout metadata meta, inout standard_metadata_t standard_metadata) {

    // @name(".ethernet_set_mac_act") action ethernet_set_mac_act(bit<48> smac, bit<48> dmac) {
    //     hdr.ethernet.srcAddr = smac;
    //     hdr.ethernet.dstAddr = dmac;
    // }
    // @name(".ethernet_set_mac") table ethernet_set_mac {
    //     actions = {
    //         ethernet_set_mac_act;
    //     }
    //     key = {
    //         standard_metadata.egress_port: exact;
    //     }
    // }

    @name("fix_checksum") action fix_checksum() {
        hdr.udp.checksum = 16w0;
    }
  

    apply {
        // if (hdr.udp.dstPort == MDS_PORT) {           
        //     ethernet_set_mac.apply();
        // }
        fix_checksum();
    }
}

control DeparserImpl(packet_out packet, in headers hdr) {
    apply {
        packet.emit<ethernet_t>(hdr.ethernet);
        packet.emit<ipv4_t>(hdr.ipv4);
        packet.emit<udp_t>(hdr.udp);
        packet.emit<map_hdr_t>(hdr.map_hdr);
    }
}

control verifyChecksum(inout headers hdr, inout metadata meta) {
    apply {
        verify_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

control computeChecksum(inout headers hdr, inout metadata meta) {
    apply {
        update_checksum(
            hdr.ipv4.isValid(),
            { hdr.ipv4.version,
            hdr.ipv4.ihl,
            hdr.ipv4.diffserv,
            hdr.ipv4.totalLen,
            hdr.ipv4.identification,
            hdr.ipv4.flags,
            hdr.ipv4.fragOffset,
            hdr.ipv4.ttl,
            hdr.ipv4.protocol,
            hdr.ipv4.srcAddr,
            hdr.ipv4.dstAddr },
            hdr.ipv4.hdrChecksum,
            HashAlgorithm.csum16);
    }
}

V1Switch<headers, metadata>(ParserImpl(), verifyChecksum(), ingress(), egress(), computeChecksum(), DeparserImpl()) main;
