struct resubmit_meta_t {
    bit<8> current_state;
    bit<32> data;
}

struct ingress_metadata_t {
    bit<1> drop;
    bit<9> egress_port;
    bit<4> packet_type;
}

register< bit<8>>(16384) current_state;
register< bit<8>>(16384) dispatch_state;
register< bit<8>>(16384) batch;

header ethernet_t {
    bit<48> dstAddr;
    bit<48> srcAddr;
    bit<16> etherType;
}

header ipv4_t {
    bit<4>  version;
    bit<4>  ihl;
    bit<8>  diffserv;
    bit<16> totalLen;
    bit<16> identification;
    bit<3>  flags;
    bit<13> fragOffset;
    bit<8>  ttl;
    bit<8>  protocol;
    bit<16> hdrChecksum;
    bit<32> srcAddr;
    bit<32> dstAddr;
}

header udp_t {
    bit<16> srcPort;
    bit<16> dstPort;
    bit<16> length_;
    bit<16> checksum;
}

header tcp_t {
    bit<16> src_port;
    bit<16> dst_port;
    bit<32> seq_no;
    bit<32> ack_no;
    bit<4>  data_offset;
    bit<3>  res;
    bit<3>  ecn;
    bit<6>  ctrl;
    bit<16> window;
    bit<16> checksum;
    bit<16> urgent_ptr;
}

//changed function_id from 8bit->32bit 
header map_hdr_t {
    bit<32> chain_id;
    bit<32> exec_id;
    bit<32> function_id;
    bit<32> data;
    bit<8> function_count;
    bit<8>  f0;
    bit<8>  f1;
    bit<8>  f2;
    bit<8>  f3;
    bit<8>  f4;
    bit<8>  autoscaling;
    // bit<8> batch_count;
}

struct exec_hdr_t {
    bit<8> function_count;
    bit<8>  function;
}


header intrinsic_metadata_t {
    bit<64> ingress_global_timestamp;
    bit<64> current_global_timestamp;
}


struct metadata {
    @name(".ing_metadata") 
    ingress_metadata_t ing_metadata;
    @name(".resubmit_meta") 
    resubmit_meta_t resubmit_meta;
    @name(".exec_hdr")
    exec_hdr_t exec_hdr;
    //@name(".intrinsic_metadata")
    //intrinsic_metadata_t intrinsic_metadata;
}

struct headers {
    @name(".ethernet") 
    ethernet_t ethernet;
    @name(".ipv4") 
    ipv4_t     ipv4;
    @name(".udp") 
    udp_t      udp;
    // @name(".tcp") 
    // tcp_t      tcp;
    @name(".map_hdr") 
    map_hdr_t map_hdr;
}