#! /bin/bash -ex

compile_flag=0
offload_flag=0
assign_ip_flag=0
location=$(pwd)
nic_function_loc="$location/../repository/nic_functions"
# cfiles=ls $nic_function_loc | egrep "*.c"
while getopts 'coi' flag; do
  case "${flag}" in
    c) compile_flag=1 ;;
    o) offload_flag=1 ;;
    i) assign_ip_flag=1 ;;
  esac
done

if [[ $compile_flag -eq 1 ]]
then
    # compile the nfp code
    sudo /opt/netronome/p4/bin/nfp4build -o ./p4src/orchestrator.nffw -p ./p4src/out -4 ./p4src/orchestrator.p4 -l lithium --nfp4c_p4_version 16 --nfirc_mac_ingress_timestamp --nfp4c_p4_compiler p4c-nfp 
    #sudo /opt/netronome/p4/bin/nfp4build -o ./p4src/orchestrator.nffw -p ./p4src/out -4 ./p4src/orchestrator.p4 -c ./p4src/memory.c ./p4src/memory2.c -l lithium --nfp4c_p4_version 16 --nfirc_mac_ingress_timestamp --nfp4c_p4_compiler p4c-nfp 
    #cd $nic_function_loc
    #files=$(./generate_names.sh)
    #cd $location
    #echo "files : $files"
    #sudo /opt/netronome/p4/bin/nfp4build -o ./p4src/orchestrator.nffw -p ./p4src/out -4 ./p4src/orchestrator.p4 -c $files  -l lithium --nfp4c_p4_version 16 --nfirc_mac_ingress_timestamp --nfp4c_p4_compiler p4c-nfp 

fi

if [[ $offload_flag -eq 1 ]]
then
  # move to p4 bin
  # cd /home/ub-01/mahendra/nfp-sdk-6.1.0-preview/p4/bin/

  # offload
  sudo /opt/netronome/p4/bin/rtecli design-load -f $location/p4src/orchestrator.nffw -c $location/p4src/echo.p4cfg -p $location/p4src/out/pif_design.json

  # returning back to base
  cd $location
fi

if [[ $assign_ip_flag -eq 1 ]]
then
    #killing all running containers
    docker stop $(docker ps -a -q) || true
    #assigning IPs to network interfaces
    sudo ./assign_ip.sh
fi
