const secrets = require('./secrets.json')
const constants = require('.././constants_local.json')

let db = new Map(), // queue holding request to be dispatched
    resourceMap = new Map(), // map between resource_id and resource details like node_id, port, associated function etc
    functionToResource = new Map(), // a function to resource map. Each map contains a minheap of
                                    // resources associated with the function
    workerNodes = new Map(), // list of worker nodes currently known to the DM
    functionBranchTree = new Map(), // a tree to store function branch predictions
    conditionProbabilityExplicit = new Map(), // tree holding conditional probabilities for explicit chains
    requestFlightQueue = new Map()// map to store in flight requests
    

/**
 * URL to the couchdb database server used to store data
 */

module.exports = {
    db, functionBranchTree, functionToResource, workerNodes, resourceMap,
    conditionProbabilityExplicit, requestFlightQueue
}
