/*
 * Creator: Naman Dixit
 * Notice: © Copyright 2020 Naman Dixit
 */

/*
 * Creator: Naman Dixit
 * Notice: © Copyright 2019 Naman Dixit
 */

#include "nlib/nlib.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include <ctype.h>
#include <assert.h>
#include <signal.h>
#include <librdkafka/rdkafka.h>


# if defined(COMPILER_CLANG)
#  pragma clang diagnostic push
#   pragma clang diagnostic ignored "-Wpadded"
#   pragma clang diagnostic ignored "-Wfloat-equal"
# endif
#include "cJSON/cJSON.h"
#include "cJSON/cJSON.c"
# if defined(COMPILER_CLANG)
#  pragma clang diagnostic pop
# endif

#include "kafka.h"

int main(int argc, char** argv)
{
    if (argc < 2) {
        printf("Error: Pass the amount of memory\n");
        exit(-1);
    }

    Sint memory_required = (Sint)strtol(argv[1], NULL, 10);

    Kafka kafka = {0};

    kafka.writer = kafkaCreateWriter(&kafka, "10.129.6.5:9092");
    kafka.reader = kafkaCreateReader(&kafka, "10.129.6.5:9092");

    rd_kafka_topic_partition_list_t *kafka_reader_topics = rd_kafka_topic_partition_list_new(1);

    kafkaSubscribe(&kafka, kafka_reader_topics, "RESPONSE_ARBITER_2_DISPATCHER");

    rd_kafka_resp_err_t kafka_reader_topics_err = rd_kafka_subscribe(kafka.reader, kafka_reader_topics);
    rd_kafka_topic_partition_list_destroy(kafka_reader_topics);

    if (kafka_reader_topics_err) {
        fprintf(stderr, "Subscribe failed: %s\n",
                rd_kafka_err2str(kafka_reader_topics_err));
        rd_kafka_destroy(kafka.reader);
        return -1;
    }

    Char *output = NULL;

    Sint id = (Sint)time(NULL);
    sbufPrint(output, "{\n\"id\": \"%d\"", id);
    sbufPrint(output, ",\n\"memory\": %d", memory_required);
    sbufPrint(output, "\n}\n");

    printf("Sending to Arbiter:\n%s\n", cJSON_Print(cJSON_Parse(output)));

    if (output != NULL) {
        if (!kafkaWrite(kafka.writer, "REQUEST_DISPATCHER_2_ARBITER", "rm_test", output)) {
            return -1;
        }
    }

    rd_kafka_message_t *kafka_message_read = rd_kafka_consumer_poll(kafka.reader, 0);
    while (true) {
        if (kafka_message_read != NULL) {
            const Char *json_error = NULL;
            cJSON *root = cJSON_ParseWithOpts((char *)kafka_message_read->payload, &json_error, true);
            Sint id_now = atoi(cJSON_GetObjectItem(root, "id")->valuestring);
            if (id_now == id) {
                break;
            } else {
                printf("Found a cranky old message: %d\n", id_now);
                rd_kafka_message_destroy(kafka_message_read);
            }
        }
        kafka_message_read = rd_kafka_consumer_poll(kafka.reader, 0);
    }

    if (kafka_message_read != NULL) {
        if (kafka_message_read->err) {
            /* Consumer error: typically just informational. */
            fprintf(stderr, "Consumer error: %s\n",
                    rd_kafka_message_errstr(kafka_message_read));
        } else {
            fprintf(stderr,
                    "Received message on %s [%d] "
                    "at offset %"PRId64": \n%s\n",
                    rd_kafka_topic_name(kafka_message_read->rkt),
                    (int)kafka_message_read->partition, kafka_message_read->offset,
                    cJSON_Print(cJSON_Parse((char *)kafka_message_read->payload)));

            char *buffer = (char *)kafka_message_read->payload;

            const Char *json_error = NULL;
            cJSON *root = cJSON_ParseWithOpts(buffer, &json_error, true);

            if (root == NULL) {
                // TODO(naman): Error
            } else {
                cJSON *array = cJSON_GetObjectItem(root, "id");
                cJSON *elem = NULL;
                cJSON_ArrayForEach(elem, array) {
                    printf("%s\n", elem->valuestring);
                }
            }
        }
        rd_kafka_message_destroy(kafka_message_read);
    }

    return 0;
}
