'use strict';
const constants = require(".././constants.json")
const config = require('./config.json')
const libSupport = require('./lib')
libSupport.updateConfig()
const node_id = config.id
const execute = require('./execute')
const fs = require('fs')
const kafka = require('kafka-node')

const local_repository = __dirname + "/local_repository/"
const host_url = "http://" + constants.master_address + ":" + constants.master_port

let usedPort = new Map()

let Producer = kafka.Producer,
    KeyedMessage = kafka.KeyedMessage,
    client = new kafka.KafkaClient({ 
        kafkaHost: constants.kafka_host,
        autoConnect: true
    }),
    producer = new Producer(client),
    Consumer = kafka.Consumer

libSupport.makeTopic(node_id).then(() => {
    console.log("node topic created")
    let consumer = new Consumer(client,
        [
            { topic: node_id, partition: 0, offset: 0 }
        ],
        [
            { autoCommit: true }
        ])
    consumer.on('message', function (message) {
        console.log(message);
        let topic = message.topic
        message = message.value
        message = JSON.parse(message)
        if (topic !== 'heartbeat') {
            let runtime = message.runtime
            let functionHash = message.functionHash
            let function_id = message.function_id
            let port = message.port
            /**
             * Download necessary files (function file) and Start resource deployment
             */
            if (message.type === "execute") {
                console.log("function_id", function_id);
                libSupport.download(host_url + "/repository/" + functionHash + ".js", local_repository + functionHash + ".js").then(() => {
                    startWorker(local_repository, functionHash, function_id, producer, runtime, port)
                })

            }
        }

    })
})
    
/**
 * Start a worker executor of the runtime type
 * @param {String} local_repository 
 * @param {String} functionHash 
 * @param {String} function_id 
 * @param {String} producer 
 * @param {String} runtime 
 * @param {Number} port 
 */
function startWorker(local_repository, functionHash, function_id, producer, runtime, port) {
    console.log("Using port", port, "for functionHash", functionHash);
    
    usedPort.set(port, functionHash)
    fs.writeFileSync('./local_repository/config.json', JSON.stringify({port}));
    if (runtime === "isolate")
        execute.runIsolate(local_repository, functionHash, port)
    else if (runtime === "process")
        execute.runProcess(local_repository, functionHash, port)
    else if (runtime === "container")
        execute.runContainer(functionHash, port)
    else {
        producer.send(
            [{
                topic: "response",
                messages: JSON.stringify({ status: "unknown runtime" })
            }], () => { })

        return
    }
}

function heartbeat() {
    let payload = [{
        topic: "heartbeat",
        messages: JSON.stringify({"address": node_id, "timestamp": Date.now()})
    }]
    producer.send(payload, function() {

    })
}

execute.workerEvent.on("start", (functionHash, port, runtime) => {
    console.log("started function Port: ", port, functionHash);
    producer.send(
        [{
            topic: "deployed",
            messages: JSON.stringify({ functionHash, port, runtime, node_id })
        }], () => { })
    
})

execute.workerEvent.on('end', (port, runtime) => {
    let functionHash = usedPort.get(port)
    usedPort.delete(port)
    producer.send(
        [{
            topic: "removeWorker",
            messages: JSON.stringify({ functionHash, port, runtime, node_id })
        }], () => {
            console.log("Ending worker for function", functionHash, usedPort);
         })
})

setInterval(heartbeat, 1000);