'use strict';
const express = require('express')
const bodyParser = require('body-parser')
const app = express()
let port = 5000
let config = null;
try {
    config = require('./config.json')
    port = config.port
} catch (e) {
    port = 5000
}

let kafka = require('kafka-node'),
    Producer = kafka.Producer,
    client = new kafka.KafkaClient({
        kafkaHost: '10.129.6.5:9092',
        autoConnect: true
    }),
    producer = new Producer(client)

app.use(bodyParser.urlencoded({ extended: true }))
app.use(bodyParser.json())
let lastRequest = Date.now()
app.post('/serverless/function/execute/', (req, res) => {
    let payload = req.body
    lastRequest = Date.now()
    executor(payload).then((result) => {
        res.json(result)
    })
})

function executor(payload) {
    return new Promise((resolve, reject) => {
    })
}

app.listen(port, () => {
    console.log(`Server listening on port ${port}!`)
    producer.send(
    [{
        topic: "response",
        messages: "ready"
    }], () => { })
})

function shouldDie() {
    
    if (Date.now() - lastRequest > 5 * 1000) {
        console.log("Idle for too long. Exiting");
        
        process.exit(0)
    }
}

setInterval(shouldDie, 1000);