const crypto = require('crypto');
const fs = require('fs')
var rp = require('request-promise');

/**
 * Generates unique IDs of arbitrary length
 * @param {Length of the ID} length 
 */
function makeid(length) {
    var result           = '';
    var characters       = 'abcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;
    for ( var i = 0; i < length; i++ ) {
       result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
 }


 /**
  * generates the runtime executor after inserting the received function
  * TODO: make this asynchronous
  * @param {string Path from where to extract the function} functionPath 
  * @param {string Function Hash value} functionHash 
  */
 function generateExecutor(functionPath, functionHash) {
   input = fs.readFileSync('./repository/worker_env/env.js')
   functionFile = fs.readFileSync(functionPath + functionHash)
   searchSize = "(resolve, reject) => {".length

   insertIndex = input.indexOf("(resolve, reject) => {") + searchSize

   output = input.slice(0, insertIndex) + functionFile + input.slice(insertIndex)
    
   let hash = crypto.createHash('md5').update(output).digest("hex");
   console.log(hash);
   
    fs.writeFileSync(functionPath + hash + ".js", output)
    return hash
 }

 function reverseProxy(req, res, url, tryout) {
    return new Promise((resolve, reject) => {
       console.log("requesting reverseproxy");

       var options = {
          method: 'POST',
          uri: url,
          body: req.body,
          json: true // Automatically stringifies the body to JSON
       };

       rp(options)
          .then(function (parsedBody) {
             console.log("parsed body:", parsedBody);
             res.json(parsedBody)
             resolve()
          })
          .catch(function (err) {
             if (err.error.errno === "ECONNREFUSED") {
                reverseProxy(req, res, url, (tryout != null) ? tryout + 1 : 1)
             } else {
                console.log("error", err.error.errno);
                res.json(err.message).status(err.statusCode)
                resolve()
             }
          });
    })
 }

 function getPort(usedPort) {
   let port = -1, ctr = 0
   do {
       min = Math.ceil(30000);
       max = Math.floor(60000);
       port = Math.floor(Math.random() * (max - min + 1)) + min;
       ctr += 1;
       if (ctr > 30000) {
           port = -1
           break
       }
   } while (usedPort.has(port))
   return port
}

 module.exports = {
    makeid, generateExecutor, reverseProxy, getPort
 }