'use strict';
// const isolateBackend = require('./isolate')
const fs = require('fs')
const { spawn } = require('child_process');
const { Worker, isMainThread, workerData } = require('worker_threads');
const registry_url = "10.129.6.5:5000/"
const events = require('events');
const workerEvent = new events.EventEmitter();
const parentProcess = require('process');

function runIsolate(local_repository, functionHash, port) {
    let filename = local_repository + functionHash + ".js"
    return new Promise((resolve, reject) => {

        const worker = new Worker(filename);
        worker.on('message', resolve);
        worker.on('error', reject);
        worker.on('exit', (code) => {
            if (code !== 0)
                reject(new Error(`Worker stopped with exit code ${code}`));
            console.log("worker exited");
            workerEvent.emit('end', port, "isolate");
        })
        worker.on('online', () => {
            workerEvent.emit('start', functionHash, port, "isolate")
            resolve()
        })
        
    });

}

function runProcess(local_repository, functionHash, port) {
    let filename = local_repository + functionHash + ".js"
    return new Promise((resolve, reject) => {
        let timeStart = Date.now()
        const process = spawn('node', [filename, port]);
        let result = "";
        process.stdout.on('data', (data) => {
            console.log(`stdout: ${data}`);
            result += data;
            let timeDifference = Math.ceil((Date.now() - timeStart))
            console.log("process time taken: ", timeDifference);
            workerEvent.emit('start', functionHash, port, "process")
            resolve(result);
        });

        process.stderr.on('data', (data) => {
            console.error(`stderr: ${data}`);
            reject(data);
        });

        process.on('close', (code) => {
            console.log(`child process exited with code ${code}`);
            workerEvent.emit('end', port, "process");
        });
    })

}


function runContainer(imageName, port) {
    console.log(imageName);

    return new Promise((resolve, reject) => {
        let timeStart = Date.now()

        const process_checkImage = spawn('docker', ["inspect", registry_url + imageName])

        process_checkImage.on('close', (code) => {
            if (code != 0) {
                const process_pullImage = spawn('docker', ["pull", registry_url + imageName]);

                process_pullImage.stderr.on('data', (data) => {
                    console.error(`stderr: ${data}`);
                    reject(data);
                });

                process_pullImage.on('close', (code) => {
                    if (code != 0)
                        reject("error")
                    else {
                        const process = spawn('docker', ["run", "--name", imageName, registry_url + imageName]);
                        let result = "";
                        timeStart = Date.now()
                        process.stdout.on('data', (data) => {
                            console.log(`stdout: ${data}`);
                            let timeDifference = Math.ceil((Date.now() - timeStart))
                            console.log("container run time taken: ", timeDifference);
                            result += data;
                            workerEvent.emit('start', imageName, port, "container")
                            resolve(result);
                        });

                        process.stderr.on('data', (data) => {
                            console.error(`stderr: ${data}`);
                            reject(data);
                        });

                        process.on('close', (code) => {
                            workerEvent.emit('end', port, "container");
                        })
                    }
                    
                })
            } else {
                const process_checkContainer = spawn('docker', ['container', 'inspect', imageName]);
                process_checkContainer.on('close', (code) => {
                    console.log("container starting at port", port);
                    
                    if (code != 0) {
                        const process = spawn('docker', ["run", "-p", `${port}:5000`, "--name", imageName, registry_url + imageName]);
                        let result = "";
                        timeStart = Date.now()
                        process.stdout.on('data', (data) => {
                            console.log(`stdout: ${data}`);
                            let timeDifference = Math.ceil((Date.now() - timeStart))
                            console.log("container run time taken: ", timeDifference);
                            // result += data;
                            workerEvent.emit('start', imageName, port, "container")
                            resolve(result);
                        });

                        process.stderr.on('data', (data) => {
                            console.error(`stderr: ${data}`);
                            reject(data);
                        });

                        process.on('close', (code) => {
                            workerEvent.emit('end', port, "container");
                        })
                    } else {
                        const clean_container = spawn('docker', ['rm', imageName])
                        clean_container.on('close', code => {
                            const process = spawn('docker', ["run", "-p", `${port}:5000`, "--name", imageName, registry_url + imageName]);
                            let result = "";
                            timeStart = Date.now()
                            process.stdout.on('data', (data) => {
                                console.log(`stdout: ${data}`);
                                let timeDifference = Math.ceil((Date.now() - timeStart))
                                console.log("container run time taken: ", timeDifference);
                                // result += data;
                                workerEvent.emit('start', imageName, port, "container")
                                resolve(result);
                            });

                            process.stderr.on('data', (data) => {
                                console.error(`stderr: ${data}`);
                                reject(data);
                            });

                            process.on('close', (code) => {
                                workerEvent.emit('end', port, "container");
                            })
                        })
                        
                    }
                })
                
            }
            
        })

        
    })

}

parentProcess.stdout.on('data', data => {
    console.log("handler", data);
    
})

module.exports.runContainer = runContainer;
module.exports.runProcess = runProcess;
module.exports.runIsolate = runIsolate;
module.exports.workerEvent = workerEvent;