/*
 * Creator: Naman Dixit
 * Notice: © Copyright 2020 Naman Dixit
 */

internal_function
noreturn
void* dockerProcessLoop (void *arg)
{
    pthread_setcanceltype (PTHREAD_CANCEL_DEFERRED, NULL);

    while (true) {
        // TODO(naman): Get data
        Char *data_cmd = NULL;
        sbufPrint(data_cmd, "docker stats %s", (Char*)arg);
        FILE* data_file = popen(data_cmd, "r");


        fseek(data_file, 0, SEEK_END);
        long size = ftell(data_file);
        fseek(data_file, 0, SEEK_SET);
        Char *data = calloc((Size)size + 1, sizeof(*data));
        fread(data, 1, (Size)size + 1, data_file);
        fclose(data_file);

        Char *json = NULL;

        Char *output = NULL;
        sbufPrint(output, "{\"node_id\": \"%s\"", node_name);
        sbufPrint(output, ",\n\"type\": \"%s\"", "docker");
        sbufPrint(output, ",\n\"data\": %s", json ? json : "{}");
        sbufPrint(output, "\n}\n");

        JSON_Print_Command jpc = {.msg = output,
                                  .topic = "LOG_CHANNEL"};

        U64 time_before = timeMilli();
        instrumentCommandEnqueue(jpc);
        U64 time_after = timeMilli();

        if ((time_after - time_before) < 1000) {
            sleep((Uint)(time_after - time_before));
        }
    }
}
