/*
 * Creator: Naman Dixit
 * Notice: © Copyright 2020 Naman Dixit
 */

typedef struct Command {
    enum Command_Kind {
        Command_NONE,
        Command_RESPONSE_ARBITER_2_DM,
        Command_REQUEST_ARBITER_2_GRUNT,
        Command_JOIN_ACK_ARBITER_2_GRUNT,
        Command_REJOIN_ARBITER_2_GRUNT,
    } kind;

    Char *resource_id;

    union {
        struct {
            Char **grunt_ids;
        } res_a2d;

        struct {
            Sint memory;
        } req_a2g;

        struct {
            Char *grunt_id;
        } rejoin_a2g;

        struct {
            Char *grunt_id;
        } join_ack_a2g;
    };
} Command;
