'use strict';
const express = require('express')
const bodyParser = require('body-parser')
const app = express()
let port = 5000, resource_id, functionHash, runtime

resource_id = process.argv[2]
functionHash = process.argv[3]
port = process.argv[4]
runtime = process.argv[5]

let kafka = require('kafka-node'),
    Producer = kafka.Producer,
    client = new kafka.KafkaClient({
        kafkaHost: '10.129.6.5:9092',
        autoConnect: true
    }),
    producer = new Producer(client)

app.use(bodyParser.urlencoded({ extended: true }))
app.use(bodyParser.json())
let lastRequest = Date.now()
app.post('/serverless/function/execute/', (req, res) => {
    let payload = req.body
    lastRequest = Date.now()
    executor(payload).then((result) => {
        res.json(result)
    })
})

function executor(payload) {
    return new Promise((resolve, reject) => {
    })
}

app.listen(port, () => {
    console.log(`Resource ${resource_id} Server listening on port ${port}!`)
    producer.send(
    [{
        topic: "deployed",
        messages: JSON.stringify({ functionHash, portExternal: port, runtime, resource_id }),
        "status": true
    }], () => { })
})

function shouldDie() {
    
    if (Date.now() - lastRequest > 30 * 1000) {
        console.log("Idle for too long. Exiting");
        producer.send(
            [{
                topic: "removeWorker",
                messages: JSON.stringify({ functionHash, portExternal: port, runtime, resource_id })
            }], () => {
                console.log("Ending worker for function", functionHash, "resource_id", resource_id);
                process.exit(0)
            })
        
    }
}

setInterval(shouldDie, 1000);