const http = require('http');
const fs = require('fs');
const process = require('process')
const { spawnSync } = require('child_process');
const constants = require(".././constants.json")
const kafka = require('kafka-node')
const winston = require('winston')
const { createLogger, format, transports } = winston;


function updateConfig() {
    console.log("Retrieving primary IP");
    let file = JSON.parse(fs.readFileSync('./config.json', { encoding: 'utf-8' }))
    const getIP = spawnSync("ip", ["route", "get", file.master_node]);
    let err = getIP.stderr.toString().trim()
    if (err !== '') {
        console.log(err);
        process.exit(1);
    }
    let data = getIP.stdout.toString().trim()
    data = data.substr(0, data.indexOf("\n")).trim()
    data = data.split(' ')
    
    file.id = data[data.length - 3]
    fs.writeFileSync('./config.json', JSON.stringify(file));
    console.log("Updated Config file");   
}

function makeTopic(id) {
    console.log("Using Primary IP", id, "as topic");
    
    let client = new kafka.KafkaClient({
        kafkaHost: constants.kafka_host,
        autoConnect: true
    }),
    Producer = kafka.Producer,
    producer = new Producer(client)
    return new Promise((resolve, reject) => {
        producer.send([{
            topic: id,
            messages: JSON.stringify({
                status: "success",
            })
        }], (err, data) => { 
            if (err)
                reject();
            else
                resolve(); 
        })
    })
}

var download = function (url, dest, cb) {
    return new Promise((resolve, reject) => {
        console.log(url);
        if (!fs.existsSync(dest)) {
            var file = fs.createWriteStream(dest);
            var request = http.get(url, function (response) {
                response.pipe(file);
                file.on('finish', function () {
                    file.close(cb);  // close() is async, call cb after close completes.
                    resolve();
                });
            }).on('error', function (err) { // Handle errors
                fs.unlink(dest); // Delete the file async. (But we don't check the result)
                if (cb) cb(err.message);
                reject(err);
            });
        } else {
            resolve();
        }
    })
    
};

function makeid(length) {
    var result = '';
    var characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;
    for (var i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
}

function returnPort(port, usedPort) {
    usedPort.delete((port))
}

const logger = winston.createLogger({
    level: 'info',
    format: winston.format.combine(
        format.timestamp(),
        format.json()
    ),
    defaultMeta: { module: 'Dispatch Agent' },
    transports: [
        //
        // - Write to all logs with level `info` and below to `combined.log` 
        // - Write all logs error (and below) to `error.log`.
        //
        new winston.transports.File({ filename: 'log/error.log', level: 'error' }),
        new winston.transports.File({ filename: 'log/combined.log' }),
        new winston.transports.Console({
            format: winston.format.combine(
                format.colorize({ all: true }),
                format.timestamp(),
                format.simple()

            )
        })
    ]
});


module.exports = {
    download, makeid, updateConfig, makeTopic, returnPort, logger
}