## Hybrid execution environment for Serverless Workloads

Execution environments are typically container oriented for FaaS platforms but this creates problems since containers are on one hand not totally secure and on the other hand not capable of high-performance. This project looks into creating a hybrid execution environment to cater to different workload needs.

### System Requirements

 - Node.js (10.x and above)
 - g++
 - build-essential

### How to execute?

 After nodejs has been installed
 - install the dependencies: execute `npm install` from within the project folder
 - run the server as `npm start` or `node index.js`

### How to interact?
The platform works via a HTTP API based interface, the interface is divided into two parts:
 - Deploy: The deploy interface is used to upload the function file and store on the server, and also setup containers and VM images. <br >
An example CURL command:
```
curl -X POST \
  http://localhost:8080/serverless/deploy \
  -H 'Content-Type: application/x-www-form-urlencoded' \
  -H 'cache-control: no-cache' \
  -H 'content-type: multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW' \
  -F runtime=container \
  -F serverless=@/home/nilanjan/Desktop/serverless/hybrid/test/script.js
```
<br> The POST request contains two parameters: 1. <emp>runtime</emp> which specifies the runtime to use viz. isolate, process, container or virtual machine and 2. <emp>severless</emp> which sends the serverless function as file via multipart/form-data.
<br> On successful deployment the API returns a function key which is to be for function execution.

 - Execute: To execute the submitted function, we use the Execute API. <br>
 An example CURL command:
 ```
 curl -X POST \
  http://localhost:8080/serverless/execute/761eec785d64451203293427bea5c7ad \
  -H 'cache-control: no-cache' \
  -H 'content-type: multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW' \
  -F runtime=process
 ```
<br> The API takes a route value as the key returned by the deploy API and a runtime parameter specifying the runtime to be used.