"use strict";

const express = require('express')
const bodyParser = require('body-parser')
const fileUpload = require('express-fileupload');

const fs = require('fs')
const { spawn } = require('child_process');
const morgan = require('morgan')
const mqtt = require('mqtt')
const client = mqtt.connect('mqtt://localhost')
const app = express()
const libSupport = require('./lib')

let db = new Map()
app.use(morgan('combined'))
app.use(bodyParser.urlencoded({ extended: false }))
app.use(bodyParser.json())
const file_path = __dirname + "/repository"

app.use('/repository', express.static(file_path));
app.use(fileUpload())

let requestQueue = []

const node_id = "20sez54hq8"
const WINDOW_SIZE = 10
const port = 8080


app.post('/serverless/deploy', (req, res) => {
    
    let runtime = req.body.runtime
    let file = req.files.serverless

    let functionHash = file.md5
    
    file.mv(file_path + functionHash, function (err) {
        if (err) {
            console.log(err);
            res.send("error").status(400)
        }
        else {
            if (runtime === "container") {
                deployContainer('./test/', functionHash)
                    .then(() => {
                        res.json({
                            status: "success",
                            function_id: functionHash
                        })
                    })
                    .catch(err => {
                        res.json({
                            status: "error",
                            reason: err}).status(400)
                    })
            } else {
                res.json({
                    status: "success",
                    function_id: functionHash
                })
            }
        }
    })
    
})

function deployContainer(path, imageName) {
    return new Promise((resolve, reject) => {
        let buildStart = Date.now()
        
        fs.writeFile('./test/Dockerfile',
            `FROM node:latest
            WORKDIR /app
            COPY package.json /app
            RUN npm install
            COPY . /app
            
            CMD node ${imageName}`
            , function (err) {
                if (err) {
                    console.log("failed", err);
                    
                    reject(err);
                }
                else {
                    console.log('Dockerfile created');
                    const process = spawn('docker', ["build", "-t", imageName, path, "-q"]);

                    process.stdout.on('data', (data) => {
                        console.log(`stdout: ${data}`);

                    });

                    process.stderr.on('data', (data) => {
                        console.error(`stderr: ${data}`);
                    });

                    process.on('close', (code) => {
                        console.log(`child process exited with code ${code}`);
                        let timeDifference = Math.ceil((Date.now() - buildStart))
                        console.log("image build time taken: ", timeDifference);
                        resolve();
                    });
                }
            });
    })
}

app.post('/serverless/execute/:id', (req, res) => {

    requestQueue.push({
        req, res
    })

    if (requestQueue.length >= WINDOW_SIZE)
        dispatch()
})


function dispatch() {
    let lookbackWindow = Math.min(WINDOW_SIZE, requestQueue.length)
    for (let i = 0; i < lookbackWindow; i++) {
        let {req, res} = requestQueue.shift()
        let runtime = req.body.runtime
        let functionHash = req.params.id
        let function_id = libSupport.makeid(20)
        console.log("Dispatching function with Id", function_id);
        
        client.publish(node_id, JSON.stringify({
            "type": "execute",
            function_id,
            runtime, functionHash
        }))
        db.set(function_id, res)
        
    }
}


client.on('message', function (topic, message) {

    if (topic === "response") {
        message = JSON.parse(message)
        console.log(message);
        let res = db.get(message.function_id)
        res.json({
            "status": "success",
            "reply": message.result
        })
        db.delete(message.function_id)
    }
})

app.listen(port, () => console.log(`Server listening on port ${port}!`))

client.on('connect', function () {
    client.subscribe("response")
})

setInterval(dispatch, 1000);