const mqtt = require('mqtt')
const client = mqtt.connect('mqtt://localhost')
const libSupport = require('../dispatcher/lib')
const execute = require('./execute')
const node_id = "20sez54hq8"

client.on('connect', function () {
    client.subscribe(node_id, function (err) {
        if (!err) {
            console.log("node listening to id", node_id);
            
        }
    })
})

client.on('message', function (topic, message) {
    // message is Buffer
    
    message = JSON.parse(message)
    if (message.type !== 'heartbeat') {
        let runtime = message.runtime
        let functionHash = message.functionHash
        let function_id = message.function_id
        console.log("function_id", function_id);
        
        if (message.type === "execute") {
            if (runtime === "isolate")
                execute.runIsolate('../dispatcher/test/' + functionHash).then( result => {
                    client.publish("response", JSON.stringify({ 
                        status: "success",
                        result,
                        function_id
                    }))
                })
            else if (runtime === "process")
                execute.runProcess('../dispatcher/test/' + functionHash).then( result => {
                    client.publish("response", JSON.stringify({
                        status: "success",
                        result,
                        function_id
                    }))
                })
            else if (runtime === "container")
                execute.runContainer(functionHash).then(result => {
                    client.publish("response", JSON.stringify({
                        status: "success",
                        result,
                        function_id
                    }))
                })
            else {
                client.publish("response", JSON.stringify({ status: "unknown runtime" }))
                return
            }
        }
    }
        
})

function heartbeat() {
    client.publish(node_id, JSON.stringify({"type": "heartbeat"}))
}

setInterval(heartbeat, 10000);