package hpdos.lib;

import java.io.Serializable;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class StorageModel implements Serializable {
    private int version;
    private int dataSize;
    private final String key; // key is immutable
    private long crc;
    private int accessType;
    private String value;
    private final String owner; // ownership is immutable

    public StorageModel(int version, int dataSize, String key, int accessType, String owner, String value) {
        this.version = version;
        this.dataSize = dataSize;
        this.key = key;
        this.accessType = accessType;
        this.value = value;
        this.owner = owner;
        // calculate CRC32 based on the value field
        byte[] bytes = value.getBytes();
        Checksum checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        this.crc = checksum.getValue();
    }

    public StorageModel createVersionUpdatedModel() {
        int updatedVersion = (this.getVersion() + 1) % Integer.MAX_VALUE; // version wraps around
        return new StorageModel(updatedVersion, this.getDataSize(),
                this.getKey(), this.getAccessType(), this.getOwner(), this.getValue());
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getDataSize() {
        return dataSize;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public String getKey() {
        return key;
    }

    public long getCrc() {
        return crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public int getAccessType() {
        return accessType;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOwner() {
        return owner;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (obj.getClass() != this.getClass())
            return false;
        StorageModel model = (StorageModel) obj;
        return this.getVersion() == model.getVersion();
    }
}

